// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef VIDEOENCODERFACTORYH264STREAMCAMERA_H
#define VIDEOENCODERFACTORYH264STREAMCAMERA_H

#include "VideoEncoderH264StreamCamera.h"

#include "api/video_codecs/sdp_video_format.h"
#include "api/video_codecs/video_encoder_factory.h"
#include "modules/video_coding/codecs/h264/include/h264.h"

#include <vector>

class VideoEncoderFactoryH264StreamCamera final : public webrtc::VideoEncoderFactory
{
public:
    VideoEncoderFactoryH264StreamCamera() {}

    ~VideoEncoderFactoryH264StreamCamera() override = default;

    std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override
    {
        RTC_LOG_F(LS_INFO) << "";
        return {CreateH264Format(webrtc::H264Profile::kProfileBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "0"),
                CreateH264Format(webrtc::H264Profile::kProfileConstrainedBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileConstrainedBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "0"),
                CreateH264Format(webrtc::H264Profile::kProfileMain,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileMain,
                                 webrtc::H264Level::kLevel3_1,
                                 "0")};
    }

    std::unique_ptr<webrtc::VideoEncoder> CreateVideoEncoder(
        const webrtc::SdpVideoFormat &format) override
    {
        RTC_LOG_F(LS_INFO);
        return VideoEncoderH264StreamCamera::Create();
    }
};

#endif // VIDEOENCODERFACTORYH264STREAMCAMERA_H
