/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <cstdint>
#include <memory>

namespace Aurora {
namespace WebView {

class IEglContextDelegate
{
public:
    virtual ~IEglContextDelegate() = default;

    virtual void GetEGLConfig(void **egl_config) = 0;
    virtual void GetEGLDisplay(void **egl_display) = 0;
    virtual void GetNativeDisplay(void **native_display) = 0;
    virtual void GetEGLGetProcAddress(void **func) = 0;
    virtual void GetEGLContextHandle(void **egl_context) = 0;
    virtual std::uint32_t CheckStickyGraphicsResetStatus() = 0;
};

using IEglContextDelegatePtr = std::shared_ptr<IEglContextDelegate>;

} // namespace WebView
} // namespace Aurora
