/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include <QObject>

namespace Aurora {
namespace WebView {

class ITextExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    ITextExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    ~ITextExtension() = default;

    virtual QString selectedText() const = 0;
    virtual void cut() = 0;
    virtual void copy() = 0;
    virtual void paste() = 0;
    virtual void clearTextSelection() = 0;
    virtual void execute(int commandId) = 0;
    virtual QSize handleSize() const = 0;
    virtual void setHandleSize(const QSize &size) = 0;

signals:
    void showMenu(QRect boundary, int availableActions);
    void hideMenu();
    void showHandle(int handleId);
    void hideHandle(int handleId);
    void handleOpacityUpdated(int handleId, float opacity);
    void handleOrientationUpdated(int handleId, int orientation);
    void moveHandle(int handleId, QPoint location);
    void executeCustomCommand(int commandId);
    void shareSelectedText(QString text);
};

} // namespace WebView
} // namespace Aurora
