/*******************************************************************************
 *
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 *
 ******************************************************************************/

#ifndef RM_LIB_TYPES_H
#define RM_LIB_TYPES_H

#include <QMetaType>
#include <QString>
#include <QVariantMap>
#include <QVector>
#include <sys/types.h>

namespace RuntimeManager {

enum class StartReason {
    Unknown = 0,
    Manual,
    Autostart,
    Intent,
    MDM,
    System,
};

enum ApplicationState {
    Starting = 0,
    Active,
    Inactive,
    Hidden,
    Terminating,
    NotRunning,
    Invalid = 255,
};

struct RunningApplication
{
    QString appInstanceId;
    pid_t pid;
    StartReason startReason;
    ApplicationState state;
    QVariantMap details;
};

struct RunningService
{
    QString appId;
    QString name;
    pid_t pid;
    StartReason startReason;
    QVariantMap details;
};

} // namespace RuntimeManager

Q_DECLARE_METATYPE(RuntimeManager::RunningApplication);
Q_DECLARE_METATYPE(RuntimeManager::RunningService);

#endif // RM_LIB_TYPES_H
