// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: MIT

#ifndef RM_LIB_LIFECYCLE
#define RM_LIB_LIFECYCLE

#include "error.h"
#include "global.h"
#include "types.h"

#include <QObject>
#include <QScopedPointer>

namespace RuntimeManager {

class LifecyclePrivate;
class RM_EXPORT Lifecycle: public QObject
{
    Q_OBJECT
public:
    static Lifecycle *instance();

    Error startService();
    Error stopService();

Q_SIGNALS:
    void stateChanged(const QString &appInstanceId,
                      const ApplicationState &state);

protected:
    Lifecycle();
    ~Lifecycle();

private:
    Q_DECLARE_PRIVATE(Lifecycle)
    QScopedPointer<LifecyclePrivate> d_ptr;
};

} // namespace RuntimeManager

#endif // RM_LIBLIFECYCLE
