/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_APPLICATION_MC_LIB_ERROR_HPP
#define AURORA_APPLICATION_MC_LIB_ERROR_HPP

#include "global.hpp"

#include <QString>

namespace Aurora {

namespace Application {

namespace ManagedConfiguration {

class AURORA_APPLICATION_MC_EXPORT Error
{
public:
    enum Code {
        NoError = 0,
        Internal,
        NotExistingKey,
        InvalidType,
        InvalidValue,
        Forbidden,
        NotConfigurable,
        InvalidUserId,
        UnsupportedType,
    };

    Error(Code code = Code::NoError, const QString &message = QString());
    ~Error() = default;

    bool isError() const;
    operator bool() const;

    Code code() const;
    QString message() const;

private:
    Code m_code;
    QString m_message;
};

} /* namespace ManagedConfiguration */

} /* namespace Application */

} /* namespace Aurora*/

#endif /* AURORA_APPLICATION_MC_LIB_ERROR_HPP */
