#ifndef VIDEOSOURCESTREAMCAMERA_H
#define VIDEOSOURCESTREAMCAMERA_H

#include "StreamCameraInfo.h"

#include "api/video/video_frame.h"
#include "api/video/video_source_interface.h"
#include "media/base/video_broadcaster.h"

#include <functional>
#include <memory>
#include <mutex>

class FrameSourceStreamCamera;

class VideoSourceStreamCamera final : public rtc::VideoSourceInterface<webrtc::VideoFrame>
{
public:
    VideoSourceStreamCamera(const VideoSourceStreamCamera &) = delete;
    VideoSourceStreamCamera(VideoSourceStreamCamera &&) = delete;
    VideoSourceStreamCamera &operator=(const VideoSourceStreamCamera &) = delete;
    VideoSourceStreamCamera &operator=(VideoSourceStreamCamera &&) = delete;

    VideoSourceStreamCamera();
    ~VideoSourceStreamCamera() override;

    rtc::VideoSinkWants wants() const;
    void RemoveSink(rtc::VideoSinkInterface<webrtc::VideoFrame> *sink) override;
    void AddOrUpdateSink(rtc::VideoSinkInterface<webrtc::VideoFrame> *sink,
                         const rtc::VideoSinkWants &wants) override;
    void RequestRefreshFrame() override;

    StreamCameraInfo CameraInfo();
    bool SetCameraMode(Aurora::StreamCamera::CameraFacing facing, int width, int height);
    int CameraMountAngle();
    void SetEncoderRotationAngleFunc(std::function<int()> encoderRotationAngle);
    bool CaptureStart();
    void CaptureStop();
    void onCameraFrameCallback(webrtc::VideoFrame &frame);

    rtc::VideoBroadcaster broadcaster_;
    FrameSourceStreamCamera* frame_source_ = nullptr;
    mutable std::mutex mutex_;
    rtc::VideoSinkWants wants_;
};

#endif // VIDEOSOURCESTREAMCAMERA_H
