#ifndef FRAMESOURCESTREAMCAMERA_H
#define FRAMESOURCESTREAMCAMERA_H

#include "FrameSource.h"
#include "StreamCameraInfo.h"
#include "StreamCameraUtil.h"
#include "StreamCameraVideoBufferNative.h"
#include "clock.h"

#include <streamcamera/streamcamera.h>

#include "api/video/i420_buffer.h"
#include "api/video/nv12_buffer.h"
#include "api/video/video_frame.h"
#include "rtc_base/logging.h"

#include <atomic>
#include <functional>
#include <memory>
#include <mutex>

class FrameSourceStreamCamera final : public FrameSource
{
public:
    class CameraListenerImpl : public Aurora::StreamCamera::CameraListener
    {
    public:
        CameraListenerImpl(FrameSourceStreamCamera &frame_source)
            : frame_source_(frame_source)
        {}
        ~CameraListenerImpl() override = default;

        void onCameraFrame(std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> buffer_shp) override
        {
            frame_source_.onCameraFrame(buffer_shp);
        }
        void onCameraError(const std::string &errorDescription) override
        {
            RTC_LOG_F(LS_ERROR) << errorDescription;
        }

        void onCameraParameterChanged(Aurora::StreamCamera::CameraParameter,
                                      const std::string &value) override
        {
            RTC_LOG_F(LS_ERROR) << value;
        }

        FrameSourceStreamCamera &frame_source_;
    };

    FrameSourceStreamCamera(std::function<void(webrtc::VideoFrame &frame)> &&onCameraFrameCallback);
    ~FrameSourceStreamCamera() override;
    webrtc::VideoFrame GetFrame() override;

    bool SetCameraMode(Aurora::StreamCamera::CameraFacing facing, int width, int height);
    bool CaptureStart();
    void CaptureStop();
    void onCameraFrame(std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> buffer_shp);
    void CameraBufferToFrame(std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> buffer_shp);
    void PrintInfo();
    void SetEncoderRotationAngleFunc(std::function<int()> encoderRotationAngleFunc);
    static webrtc::VideoFrame EmptyFrame(int width, int height);

    size_t camera_num_ = 0;
    size_t camera_mode_num_ = 0;
    std::vector<Aurora::StreamCamera::PixelFormat> pixel_format_list_;

    Aurora::StreamCamera::CameraManager &camera_manager_;
    StreamCameraInfo camera_info_;
    CameraListenerImpl camera_listener_;
    std::shared_ptr<Aurora::StreamCamera::Camera> camera_ = nullptr;

    int width_ = 0;
    int height_ = 0;
    int fps_ = 0;
    int mountAngle_;

private:
    std::function<void(webrtc::VideoFrame &frame)> onCameraFrameCallback_;
    std::function<int()> encoderRotationAngleFunc_ = [](){ return 0; };
    std::mutex mutex_;
};

#endif // FRAMESOURCESTREAMCAMERA_H
