#ifndef AUDIODEVICEMODULEPULSE_H
#define AUDIODEVICEMODULEPULSE_H

#include "api/sequence_checker.h"
#include "modules/audio_device/audio_device_buffer.h"
#include "modules/audio_device/fine_audio_buffer.h"
#include "modules/audio_device/include/audio_device.h"
#include "modules/audio_device/include/audio_device_defines.h"
#include "modules/audio_device/linux/audio_mixer_manager_pulse_linux.h"
#include "modules/audio_device/linux/pulseaudiosymboltable_linux.h"
#include "modules/audio_device/linux/audio_device_pulse_linux.h"
#include "rtc_base/event.h"
#include "rtc_base/platform_thread.h"
#include "rtc_base/synchronization/mutex.h"
#include "rtc_base/thread_annotations.h"

#include <pulse/pulseaudio.h>

#include <atomic>
#include <memory>

class AudioDeviceModulePulse : public webrtc::AudioDeviceModule
{
public:
    AudioDeviceModulePulse(webrtc::TaskQueueFactory *task_queue_factory);
    ~AudioDeviceModulePulse() override;

    int32_t ActiveAudioLayer(webrtc::AudioDeviceModule::AudioLayer *audioLayer) const override;
    int32_t RegisterAudioCallback(webrtc::AudioTransport *audioCallback) override;

    int32_t Init() override;
    int32_t Terminate() override;
    bool Initialized() const override;

    int16_t PlayoutDevices() override;
    int16_t RecordingDevices() override;
    int32_t PlayoutDeviceName(uint16_t index,
                              char name[webrtc::kAdmMaxDeviceNameSize],
                              char guid[webrtc::kAdmMaxGuidSize]) override;
    int32_t RecordingDeviceName(uint16_t index,
                                char name[webrtc::kAdmMaxDeviceNameSize],
                                char guid[webrtc::kAdmMaxGuidSize]) override;

    // call from media/engine/adm_helpers.cc Init()
    int32_t SetPlayoutDevice(uint16_t index) override;
    int32_t SetPlayoutDevice(WindowsDeviceType device) override;
    int32_t SetRecordingDevice(uint16_t index) override;
    int32_t SetRecordingDevice(WindowsDeviceType device) override;

    int32_t PlayoutIsAvailable(bool *available) override;
    int32_t InitPlayout() override;
    bool PlayoutIsInitialized() const override;
    int32_t RecordingIsAvailable(bool *available) override;
    int32_t InitRecording() override;
    bool RecordingIsInitialized() const override;

    int32_t StartPlayout() override;
    int32_t StopPlayout() override;
    bool Playing() const override;
    int32_t StartRecording() override;
    int32_t StopRecording() override;
    bool Recording() const override;

    // call from media/engine/adm_helpers.cc Init()
    int32_t InitSpeaker() override;
    bool SpeakerIsInitialized() const override;
    int32_t InitMicrophone() override;
    bool MicrophoneIsInitialized() const override;

    int32_t SpeakerVolumeIsAvailable(bool *available) override;
    int32_t SetSpeakerVolume(uint32_t volume) override;
    int32_t SpeakerVolume(uint32_t *volume) const override;
    int32_t MaxSpeakerVolume(uint32_t *maxVolume) const override;
    int32_t MinSpeakerVolume(uint32_t *minVolume) const override;

    int32_t MicrophoneVolumeIsAvailable(bool *available) override;
    int32_t SetMicrophoneVolume(uint32_t volume) override;
    int32_t MicrophoneVolume(uint32_t *volume) const override;
    int32_t MaxMicrophoneVolume(uint32_t *maxVolume) const override;
    int32_t MinMicrophoneVolume(uint32_t *minVolume) const override;

    int32_t SpeakerMuteIsAvailable(bool *available) override;
    int32_t SetSpeakerMute(bool enable) override;
    int32_t SpeakerMute(bool *enabled) const override;

    int32_t MicrophoneMuteIsAvailable(bool *available) override;
    int32_t SetMicrophoneMute(bool enable) override;
    int32_t MicrophoneMute(bool *enabled) const override;

    // call from media/engine/adm_helpers.cc Init()
    int32_t StereoPlayoutIsAvailable(bool *available) const override;
    int32_t SetStereoPlayout(bool enable) override;
    int32_t StereoPlayout(bool *enabled) const override;
    int32_t StereoRecordingIsAvailable(bool *available) const override;
    int32_t SetStereoRecording(bool enable) override;
    int32_t StereoRecording(bool *enabled) const override;

    int32_t PlayoutDelay(uint16_t *delayMS) const override;

    bool BuiltInAECIsAvailable() const override;
    int32_t EnableBuiltInAEC(bool enable) override;
    bool BuiltInAGCIsAvailable() const override;
    int32_t EnableBuiltInAGC(bool enable) override;
    bool BuiltInNSIsAvailable() const override;
    int32_t EnableBuiltInNS(bool enable) override;

public:
    void Lock() RTC_EXCLUSIVE_LOCK_FUNCTION(mutex_) { mutex_.Lock(); }
    void UnLock() RTC_UNLOCK_FUNCTION(mutex_) { mutex_.Unlock(); }
    void WaitForOperationCompletion(pa_operation *paOperation) const;
    void WaitForSuccess(pa_operation *paOperation) const;

    static void PaContextStateCallback(pa_context *c, void *pThis);
    static void PaSinkInfoCallback(pa_context *c, const pa_sink_info *i, int eol, void *pThis);
    static void PaSourceInfoCallback(pa_context *c, const pa_source_info *i, int eol, void *pThis);
    static void PaServerInfoCallback(pa_context *c, const pa_server_info *i, void *pThis);
    static void PaStreamStateCallback(pa_stream *p, void *pThis);
    void PaContextStateCallbackHandler(pa_context *c);
    void PaSinkInfoCallbackHandler(const pa_sink_info *i, int eol);
    void PaSourceInfoCallbackHandler(const pa_source_info *i, int eol);
    void PaServerInfoCallbackHandler(const pa_server_info *i);
    void PaStreamStateCallbackHandler(pa_stream *p);

    void EnableWriteCallback();
    void DisableWriteCallback();
    static void PaStreamWriteCallback(pa_stream *unused, size_t buffer_space, void *pThis);
    void PaStreamWriteCallbackHandler(size_t buffer_space);
    static void PaStreamUnderflowCallback(pa_stream *unused, void *pThis);
    void PaStreamUnderflowCallbackHandler();
    void EnableReadCallback();
    void DisableReadCallback();
    static void PaStreamReadCallback(pa_stream *unused1, size_t unused2, void *pThis);
    void PaStreamReadCallbackHandler();
    static void PaStreamOverflowCallback(pa_stream *unused, void *pThis);
    void PaStreamOverflowCallbackHandler();
    int32_t LatencyUsecs(pa_stream *stream);
    int32_t ReadRecordedData(const void *bufferData, size_t bufferSize);
    int32_t ProcessRecordedData(int8_t *bufferData, uint32_t bufferSizeInSamples, uint32_t recDelay);

    int32_t CheckPulseAudioVersion();
    int32_t InitSamplingFrequency();
    int32_t GetDefaultDeviceInfo(bool recDevice, char *name, uint16_t &index);
    int32_t InitPulseAudio();
    int32_t TerminatePulseAudio();

    void PaLock();
    void PaUnLock();

    static void RecThreadFunc(void *);
    static void PlayThreadFunc(void *);
    bool RecThreadProcess() RTC_LOCKS_EXCLUDED(mutex_);
    bool PlayThreadProcess() RTC_LOCKS_EXCLUDED(mutex_);

    std::unique_ptr<webrtc::AudioDeviceBuffer> _ptrAudioBuffer;

    mutable webrtc::Mutex mutex_;
    rtc::Event _timeEventRec;
    rtc::Event _timeEventPlay;
    rtc::Event _recStartEvent;
    rtc::Event _playStartEvent;

    rtc::PlatformThread _ptrThreadPlay;
    rtc::PlatformThread _ptrThreadRec;

    webrtc::AudioMixerManagerLinuxPulse _mixerManager;

    uint16_t _inputDeviceIndex;
    uint16_t _outputDeviceIndex;
    bool _inputDeviceIsSpecified;
    bool _outputDeviceIsSpecified;

    int sample_rate_hz_;
    uint8_t _recChannels;
    uint8_t _playChannels;

    // Stores thread ID in constructor.
    // We can then use RTC_DCHECK_RUN_ON(&worker_thread_checker_) to ensure that
    // other methods are called from the same thread.
    // Currently only does RTC_DCHECK(thread_checker_.IsCurrent()).
    webrtc::SequenceChecker thread_checker_;

    bool _initialized;
    bool _recording;
    bool _playing;
    bool _recIsInitialized;
    bool _playIsInitialized;
    bool _startRec;
    bool _startPlay;
    bool update_speaker_volume_at_startup_;
    bool quit_ RTC_GUARDED_BY(&mutex_);

    uint32_t _sndCardPlayDelay RTC_GUARDED_BY(&mutex_);

    void SetTypingStatus(bool typing);

    int32_t _writeErrors;

    uint16_t _deviceIndex;
    int16_t _numPlayDevices;
    int16_t _numRecDevices;
    char *_playDeviceName;
    char *_recDeviceName;
    char *_playDisplayDeviceName;
    char *_recDisplayDeviceName;
    char _paServerVersion[32];

    int8_t *_playBuffer;
    size_t _playbackBufferSize;
    size_t _playbackBufferUnused;
    size_t _tempBufferSpace;
    int8_t *_recBuffer;
    size_t _recordBufferSize;
    size_t _recordBufferUsed;
    const void *_tempSampleData;
    size_t _tempSampleDataSize;
    int32_t _configuredLatencyPlay;
    int32_t _configuredLatencyRec;

    // PulseAudio
    uint16_t _paDeviceIndex;
    bool _paStateChanged;

    pa_threaded_mainloop *_paMainloop;
    pa_mainloop_api *_paMainloopApi;
    pa_context *_paContext;

    pa_stream *_recStream;
    pa_stream *_playStream;
    uint32_t _recStreamFlags;
    uint32_t _playStreamFlags;
    pa_buffer_attr _playBufferAttr;
    pa_buffer_attr _recBufferAttr;

    std::atomic<bool> _typing = ATOMIC_VAR_INIT(false);
};

#endif // AUDIODEVICEMODULEPULSE_H
