/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include <callserviceglobal.h>

namespace ru {
namespace auroraos {
namespace call {

class CallManager;
class AudioContextPrivate;

class CALLSERVICE_EXPORT AudioContext : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool enabled READ enabled WRITE setEnabled NOTIFY enabledChanged)
    Q_PROPERTY(bool callStateForced READ callStateForced WRITE setCallStateForced NOTIFY callStateForcedChanged)
    Q_PROPERTY(Type context READ context NOTIFY contextChanged)
    Q_PROPERTY(Type defaultContext READ defaultContext NOTIFY defaultContextChanged)

public:
    enum class Type {
        Denied,
        Player,
        VoIP
    };
    Q_ENUM(Type)

public:
    explicit AudioContext(CallManager *);
    virtual ~AudioContext();

    bool enabled() const;
    void setEnabled(bool enabled);

    bool callStateForced() const;
    void setCallStateForced(bool forced);

    Type context() const;

    Type defaultContext() const;
    void setDefaultContext(AudioContext::Type type);

signals:
    void enabledChanged(bool);
    void callStateForcedChanged(bool);
    void contextChanged(AudioContext::Type);
    void defaultContextChanged(AudioContext::Type);

private:
    Q_DISABLE_COPY(AudioContext)
    Q_DECLARE_PRIVATE(AudioContext)
    Q_PRIVATE_SLOT(d_func(), void _q_release());
    AudioContextPrivate *d_ptr;
};

} // namespace call
} // namespace auroraos
} // namespace ru
