    /* This file is part of the Aurora OS SDK
*/

var merSdkVMSshPort = "2222";
var merSdkVMDBusPort = "7777";

function Component()
{
    console.log("Component constructor: " + component.name);

    installer.setValue("merSdkVMSshPort", merSdkVMSshPort);
    installer.setValue("merSdkVMDBusPort", merSdkVMDBusPort);
}

function toNativePath(path)
{
    if (installer.value("os") === "win")
        return path.replace(/\//g, "\\");
    else
        return path;
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    var deviceModels = installer.componentByName("org.merproject.emulators").deviceModels;
    deviceModels.forEach(addMerDeviceModelToQtCreator);

    var targetDir = installer.value("TargetDir");
    var sharedConfigDir = targetDir + "/vmshare"
    var sshKeyDir = sharedConfigDir + "/ssh/private_keys";

    component.registerPathForUninstallation(sharedConfigDir + "/devices.xml");
    component.registerPathForUninstallation(sharedConfigDir, true);
    
    installer.setValue("merSdkSshKeyPublicFile", sshKeyDir + "/sdk.pub");

    var merSdkSshKeyFile = sshKeyDir + "/sdk";
    var merSdkSshKeyPublicFile = sshKeyDir + "/sdk.pub";

   installer.setValue("merSdkSshKeyFile", merSdkSshKeyFile);
   installer.setValue("merSdkSshKeyPublicFile", merSdkSshKeyPublicFile);

    //generate ssh keys
    component.addOperation("Mkdir", sshKeyDir);
    component.addOperation("Execute", ["@merSshPath@", "generatesshkeys", "'@merSdkSshKeyFile@'" ]);
    component.registerPathForUninstallation(merSdkSshKeyFile);
    component.registerPathForUninstallation(merSdkSshKeyPublicFile);
}

function addMerDeviceModelToQtCreator(deviceModel)
{
    var sdkTool = installer.value("SDKToolBinary");
    var installDir = installer.value("TargetDir");

    var errorMessage = "errormessage=" +  qsTranslate("installscript", "Could not remove the device model \"%1\"").arg(deviceModel.name);
    component.addOperation("Execute", ["{0,2,3}", sdkTool, "rmSfdkDeviceModel",
                                       "--name", deviceModel.name, errorMessage]);
    component.addOperation("Execute", ["{0,1}", sdkTool, "addSfdkDeviceModel",
                                       "--installdir", installDir,
                                       "--name", deviceModel.name,
                                       "--hres-px", deviceModel.hres_px,
                                       "--vres-px", deviceModel.vres_px,
                                       "--hsize-mm", deviceModel.hsize_mm,
                                       "--vsize-mm", deviceModel.vsize_mm,
                                       "--dconf-db", deviceModel.dconfDb,
                                       "UNDOEXECUTE",
                                       "{0,1}", sdkTool, "rmSfdkDeviceModel",
                                       "--name", deviceModel.name, errorMessage
                           ]);
}
