/* This file is part of the Aurora OS SDK
*/

function dconfDbCommonPrelude(pixel_ratio)
{
    var icon_res = pixel_ratio;
    return "[desktop/sailfish/silica]\n" +
        `theme_pixel_ratio=${pixel_ratio}\n` +
        `theme_icon_subdir='z${icon_res}'\n`;
}

var deviceModelDconfDb_p4903 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.2\n" +
    "theme_icon_subdir='z1.2'\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_ns220 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=0.9\n" +
    "theme_icon_subdir='z0.9'\n" +
    "default_allowed_orientations=11\n";

var deviceModelDconfDb_qmp_m1_n = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.1\n" +
    "theme_icon_subdir='z1.1'\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_t8 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_ns208 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.0\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_bv6000s = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_c55 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.09\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_pl10_66 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=0.9\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_mashtab_t1 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_f_r570 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_aq_nsm11 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.75\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_qmp_m1_n_ip = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_pine64 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.0\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfDb_t800 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_t800_720p = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=0.75\n" +
    "default_allowed_orientations=1\n";

var deviceModelDconfDb_t1100 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfMvkt2101 = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfNS208RH = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1.25\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfNS220RE = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1\n" +
    "default_allowed_orientations=3\n";

var deviceModelDconfKvadraT = "[desktop/sailfish/silica]\n" +
    "theme_pixel_ratio=1\n" +
    "default_allowed_orientations=3\n";

function DeviceModel(name, hres_px, vres_px, hsize_mm, vsize_mm, dconfDb)
{
    this.name = name;
    this.hres_px = hres_px;
    this.vres_px = vres_px;
    this.hsize_mm = hsize_mm;
    this.vsize_mm = vsize_mm;
    this.dconfDb = dconfDb;
}

DeviceModel.prototype.isScaledDown = function()
{
    // TODO decide based on screen size
    return true;
}

DeviceModel.prototype.scaleDownFactor = function()
{
    return this.isScaledDown() ? 2 : 1;
}

DeviceModel.prototype.eglfConfig = function()
{
    return "QT_QPA_EGLFS_SCALE=" + this.scaleDownFactor() + "\n" +
        "QT_QPA_EGLFS_WIDTH=" + this.hres_px + "\n" +
        "QT_QPA_EGLFS_HEIGHT=" + this.vres_px + "\n" +
        "QT_QPA_EGLFS_PHYSICAL_WIDTH=" + this.hsize_mm + "\n" +
        "QT_QPA_EGLFS_PHYSICAL_HEIGHT=" + this.vsize_mm + "\n" +
        "BOOT_SCREEN_ROTATION=" + (this.hsize_mm < this.vsize_mm ? 0 : 90) + "\n";
}

DeviceModel.prototype.compositorConfig = function()
{
    const os = installer.value('os');
    var device = "/dev/input/event1";

    if (os === "mac"
            && systemInfo.currentCpuArchitecture !== "i386"
            && systemInfo.currentCpuArchitecture !== "x86_64")
        device = "/dev/input/event0";

    return "EGL_PLATFORM=drm\n" +
        "QT_QPA_PLATFORM=eglfs\n" +
        "QT_QPA_EGLFS_DEPTH=32\n" +
        "# Comment/uncomment this line only using \"Emulator mode\" UI (turn off/on touch-plugin)\n" +
        "LIPSTICK_LIBINPUT_OPTIONS=-plugin VBoxTouch:qemu:evdev=" + device + "\n" +
        "QT_QPA_EVDEV_MOUSE_PARAMETERS=/dev/nomouse\n";
}

DeviceModel.prototype.qemuTouchRules = function()
{
    return "# Comment/uncomment this line only using \"Emulator mode\" UI (disable/enable qemu device for libinput)\n" +
        "ATTRS{name}==\"QEMU Virtio Tablet\", ENV{LIBINPUT_IGNORE_DEVICE}=\"1\"\n";
}

DeviceModel.prototype.videoMode = function()
{
    var hres_px = this.hres_px / this.scaleDownFactor();
    var vres_px = this.vres_px / this.scaleDownFactor();
    var depth = 32;
    return hres_px + "x" + vres_px + "x" + depth;
}

DeviceModel.prototype.guestSizeHint = function()
{
    var hres_px = this.hres_px / this.scaleDownFactor();
    var vres_px = this.vres_px / this.scaleDownFactor();
    return hres_px + "," + vres_px;
}

var deviceModels = [
    new DeviceModel("Mashtab TrustPhone T1", 720, 1600, 68, 152, deviceModelDconfDb_mashtab_t1),
    new DeviceModel("Aquarius NS M11", 1080, 2400, 69, 155, deviceModelDconfDb_aq_nsm11),
    new DeviceModel("Aquarius NS M12", 1080, 2400, 69, 155, deviceModelDconfDb_aq_nsm11),
    new DeviceModel("Aquarius NS M12v2", 1080, 2400, 69, 155, deviceModelDconfDb_aq_nsm11),
    new DeviceModel("Aquarius NS M21", 1080, 2400, 69, 155, deviceModelDconfDb_aq_nsm11), 
    new DeviceModel("Byterg MVK-T2101", 2000, 1200, 240, 144, deviceModelDconfMvkt2101),
    new DeviceModel("Aquarius NS220RE", 1920, 1280, 222, 148, deviceModelDconfNS220RE),
    new DeviceModel("Aquarius NS208RH", 1920, 1280, 222, 148, deviceModelDconfNS208RH),
    new DeviceModel("F+ R570Е", 720, 1440, 65, 130, deviceModelDconfDb_f_r570),
    new DeviceModel("F+ T800", 1200, 1920, 172, 107, deviceModelDconfDb_t800),
    new DeviceModel("F+ T800 (720p)", 1280, 720, 172, 107, deviceModelDconfDb_t800_720p),
    new DeviceModel("F+ T1100", 1600, 2176, 166, 226, deviceModelDconfDb_t1100),
    new DeviceModel("Kvadra KVADRA_T", 2000, 1200, 235, 140, deviceModelDconfKvadraT)
    ];

    var initialDeviceModel = deviceModels[0];

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Emulators"));
    component.setValue("Description", component.value("DisplayName"));
    component.deviceModels = deviceModels;
    component.initialDeviceModel = initialDeviceModel;
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    component.addOperation("Mkdir", "@TargetDir@/emulator/media/");
}
