// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_LAYOUT_NG_INLINE_NG_TEXT_TYPE_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_LAYOUT_NG_INLINE_NG_TEXT_TYPE_H_

namespace blink {

// Type of text nodes and fragments.
enum class NGTextType {
  // Normal text from |text_content_| in |NGNodeInlineData|. It is from
  // the box-tree; i.e., originated from DOM text nodes, or content generated by
  // pseudo elements.
  kNormal,
  // Forced line break, either from <br> element or preserved new line
  // characters.
  kForcedLineBreak,
  // Flow controls are not to be painted. In particular, a tabulation
  // character and a soft-wrap opportunity.
  kFlowControl,
  kSymbolMarker,
  // This text is generated by layout, e.g. hyphens and ellipsis, not from
  // |LayoutText| nor from |NGNodeInlineData|.
  // Note: Contents generated by CSS pseudo element, e.g. ::before, ::after,
  // are not classified to this. See |IsStyleGenerated()| for them.
  kLayoutGenerated,
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_LAYOUT_NG_INLINE_NG_TEXT_TYPE_H_
