/****************************************************************************************
**
** SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2015 Jolla Ltd.
** All rights reserved.
**
** License: Proprietary
**
****************************************************************************************/

#ifndef SILICASCREEN_H
#define SILICASCREEN_H

#include <silicaglobal.h>
#include <QObject>

namespace Silica
{

class ScreenPrivate;

class SAILFISH_SILICA_EXPORT Screen : public QObject
{
    Q_OBJECT
    Q_ENUMS(SizeCategory)
    Q_PROPERTY(int width READ width FINAL CONSTANT)
    Q_PROPERTY(int height READ height FINAL CONSTANT)
    Q_PROPERTY(qreal widthRatio READ widthRatio FINAL CONSTANT)
    Q_PROPERTY(SizeCategory sizeCategory READ sizeCategory FINAL CONSTANT)
    Q_PROPERTY(bool _isTablet READ isTablet FINAL CONSTANT)
    Q_PROPERTY(bool _isPhablet READ isPhablet FINAL CONSTANT)

public:
    enum SizeCategory {
        Small,
        Medium,
        Large,
        ExtraLarge
    };

    // For C++
    static Screen *instance();

    // For QML plugin
    explicit Screen(QObject *parent = 0);
    ~Screen();

    int width() const;
    int height() const;
    qreal widthRatio() const;
    SizeCategory sizeCategory() const;
    bool isTablet() const;
    bool isPhablet() const;

private:
    ScreenPrivate *m_private;

};

}

#endif // SILICASCREEN_H
