#ifndef STREAMCAMERAVIDEOBUFFERNV12_H
#define STREAMCAMERAVIDEOBUFFERNV12_H

#include <streamcamera/streamcamera.h>

#include "api/video/i420_buffer.h"
#include "api/video/nv12_buffer.h"
#include "api/video/video_frame_buffer.h"
#include "third_party/libyuv/include/libyuv.h"
#include "common_video/libyuv/include/webrtc_libyuv.h"

#include <memory>

class StreamCameraVideoBufferNV12 : public webrtc::NV12BufferInterface
{
public:
    static rtc::scoped_refptr<StreamCameraVideoBufferNV12> Create(
        std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
    {
        return rtc::make_ref_counted<StreamCameraVideoBufferNV12>(frame);
    }

    StreamCameraVideoBufferNV12(std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
        : ycbcr(frame)
    {
        RTC_DCHECK(frame->chromaStep == 2);
    }

    Type type() const override { return Type::kNV12; }

    int width() const override { return ycbcr->width; };
    int height() const override { return ycbcr->height; };

    int StrideY() const override { return ycbcr->yStride; }
    int StrideUV() const override { return ycbcr->cStride; }

    const uint8_t *DataY() const override { return (const uint8_t *) ycbcr->y; };
    const uint8_t *DataUV() const override { return (const uint8_t *) ycbcr->cb; };

    rtc::scoped_refptr<webrtc::I420BufferInterface> ToI420() override
    {
        rtc::scoped_refptr<webrtc::I420Buffer> buffer = webrtc::I420Buffer::Create(ycbcr->width,
                                                                                   ycbcr->height);
        libyuv::NV12ToI420((const uint8_t *) ycbcr->y,
                           ycbcr->yStride,
                           (const uint8_t *) ycbcr->cb,
                           ycbcr->cStride,
                           buffer->MutableDataY(),
                           buffer->StrideY(),
                           buffer->MutableDataU(),
                           buffer->StrideU(),
                           buffer->MutableDataV(),
                           buffer->StrideV(),
                           ycbcr->width,
                           ycbcr->height);
        return buffer;
    }

    std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> ycbcr;
};

#endif // STREAMCAMERAVIDEOBUFFERNV12_H
