#ifndef STREAMCAMERAVIDEOBUFFERI420_H
#define STREAMCAMERAVIDEOBUFFERI420_H

#include <streamcamera/streamcamera.h>

#include "api/video/i420_buffer.h"
#include "api/video/video_frame_buffer.h"
#include "rtc_base/ref_counted_object.h"

#include <memory>

class StreamCameraVideoBufferI420 : public webrtc::I420BufferInterface
{
public:
    static rtc::scoped_refptr<StreamCameraVideoBufferI420> Create(
        std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
    {
        return rtc::scoped_refptr<StreamCameraVideoBufferI420>(new rtc::RefCountedObject<StreamCameraVideoBufferI420>(frame));
    }

    static rtc::scoped_refptr<StreamCameraVideoBufferI420> Create(
        const Aurora::StreamCamera::YCbCrFrame *frame)
    {
        return rtc::scoped_refptr<StreamCameraVideoBufferI420>(new rtc::RefCountedObject<StreamCameraVideoBufferI420>(frame));
    }

    StreamCameraVideoBufferI420(std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
        : ycbcr(frame)
    {
        RTC_DCHECK(frame->chromaStep == 1);
    }

    StreamCameraVideoBufferI420(const Aurora::StreamCamera::YCbCrFrame *frame)
        : ycbcr(frame)
    {
        RTC_DCHECK(frame->chromaStep == 1);
    }

    Type type() const override { return Type::kI420; }

    int width() const override { return ycbcr->width; };
    int height() const override { return ycbcr->height; };

    const uint8_t *DataY() const { return (const uint8_t *) ycbcr->y; };
    const uint8_t *DataU() const { return (const uint8_t *) ycbcr->cb; };
    const uint8_t *DataV() const { return (const uint8_t *) ycbcr->cr; };

    int StrideY() const override { return ycbcr->yStride; };
    int StrideU() const override { return ycbcr->cStride; };
    int StrideV() const override { return ycbcr->cStride; };

    std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> ycbcr;
};

#endif // STREAMCAMERAVIDEOBUFFERI420_H
