/* This file is part of the Aurora OS SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "QEMU"));
    component.setValue("Description", qsTranslate("installscript", "QEMU executable and libs for run Aurora Emulator."));
}
Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();
}

Component.prototype.createOperationsForArchive = function(archive)
{
    component.addOperation("Mkdir", "@TargetDir@/share/qemu");
    component.addOperation("Extract", archive, "@TargetDir@/share/qemu");

    if (systemInfo.kernelType === "winnt") {
        installer.setValue("qemuPath", "@TargetDir@/share/qemu");
    }
    else {
        installer.setValue("qemuPath", "@TargetDir@/share/qemu/bin");
    }
}
