/* This file is part of the Aurora OS SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Qt Linguist"));
    component.setValue("Description", qsTranslate("installscript", "Qt Linguist is a tool for translating text in apps."));
}

Component.prototype.beginInstallation = function()
{
    var os = installer.value("os");

    if (os === "win")
        component.setStopProcessForUpdateRequest("linguist.exe", true);
    else if (os === "mac")
        component.setStopProcessForUpdateRequest("Linguist", true);
    else
        component.setStopProcessForUpdateRequest("linguist", true);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();
}
