/* THIS FILE IS AUTOGENERATED FROM WebExtensionContentScript.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WebExtensionContentScriptBinding_h
#define mozilla_dom_WebExtensionContentScriptBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

namespace dom {

class MatchGlobOrString;
class MatchPatternSetOrStringSequence;
struct MozDocumentMatcherInitAtoms;
struct NativePropertyHooks;
class OwningMatchGlobOrString;
class OwningMatchPatternSetOrStringSequence;
class ProtoAndIfaceCache;
struct WebExtensionContentScriptInitAtoms;

} // namespace dom

namespace extensions {

class MatchGlob;
class MatchPatternSet;
class MozDocumentMatcher;
struct MozDocumentMatcherAtoms;
class WebExtensionContentScript;
struct WebExtensionContentScriptAtoms;

} // namespace extensions

} // namespace mozilla

namespace mozilla {
namespace dom {

enum class ContentScriptRunAt : uint8_t {
  Document_start,
  Document_end,
  Document_idle,
  EndGuard_
};

namespace ContentScriptRunAtValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ContentScriptRunAt::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(ContentScriptRunAt stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace ContentScriptRunAtValues

bool
ToJSValue(JSContext* aCx, ContentScriptRunAt aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMatchGlobOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMatchPatternSetOrStringSequence& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMatchGlobOrString& aUnion);


void
ImplCycleCollectionUnlink(OwningMatchPatternSetOrStringSequence& aUnion);


class MatchGlobOrString
{
  friend class MatchGlobOrStringArgument;
  enum Type
  {
    eUninitialized,
    eMatchGlob,
    eString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::extensions::MatchGlob> > mMatchGlob;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  MatchGlobOrString(const MatchGlobOrString&) = delete;
  MatchGlobOrString& operator=(const MatchGlobOrString&) = delete;
public:
  explicit inline MatchGlobOrString()
    : mType(eUninitialized)
  {
  }

  inline ~MatchGlobOrString()
  {
    Uninit();
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  RawSetAsMatchGlob()
  {
    if (mType == eMatchGlob) {
      return mValue.mMatchGlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMatchGlob;
    return mValue.mMatchGlob.SetValue();
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  SetAsMatchGlob()
  {
    if (mType == eMatchGlob) {
      return mValue.mMatchGlob.Value();
    }
    Uninit();
    mType = eMatchGlob;
    return mValue.mMatchGlob.SetValue();
  }

  inline bool
  IsMatchGlob() const
  {
    return mType == eMatchGlob;
  }

  inline NonNull<mozilla::extensions::MatchGlob>&
  GetAsMatchGlob()
  {
    MOZ_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline mozilla::extensions::MatchGlob&
  GetAsMatchGlob() const
  {
    MOZ_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMatchGlob: {
        DestroyMatchGlob();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyMatchGlob()
  {
    MOZ_ASSERT(IsMatchGlob(), "Wrong type!");
    mValue.mMatchGlob.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningMatchGlobOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMatchGlobOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eMatchGlob,
    eString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::extensions::MatchGlob> > mMatchGlob;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningMatchGlobOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningMatchGlobOrString(const OwningMatchGlobOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMatchGlobOrString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::extensions::MatchGlob>&
  RawSetAsMatchGlob();

  OwningNonNull<mozilla::extensions::MatchGlob>&
  SetAsMatchGlob();

  bool
  TrySetToMatchGlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchGlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMatchGlob() const
  {
    return mType == eMatchGlob;
  }

  inline OwningNonNull<mozilla::extensions::MatchGlob>&
  GetAsMatchGlob()
  {
    MOZ_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  inline OwningNonNull<mozilla::extensions::MatchGlob> const &
  GetAsMatchGlob() const
  {
    MOZ_ASSERT(IsMatchGlob(), "Wrong type!");
    return mValue.mMatchGlob.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMatchGlobOrString&
  operator=(const OwningMatchGlobOrString& aOther);

private:
  void
  DestroyMatchGlob();

  void
  DestroyString();
};


class MatchPatternSetOrStringSequence
{
  friend class MatchPatternSetOrStringSequenceArgument;
  enum Type
  {
    eUninitialized,
    eMatchPatternSet,
    eStringSequence
  };

  union Value
  {
    UnionMember<NonNull<mozilla::extensions::MatchPatternSet> > mMatchPatternSet;
    UnionMember<binding_detail::AutoSequence<nsString> > mStringSequence;

  };

  Type mType;
  Value mValue;

  MatchPatternSetOrStringSequence(const MatchPatternSetOrStringSequence&) = delete;
  MatchPatternSetOrStringSequence& operator=(const MatchPatternSetOrStringSequence&) = delete;
public:
  explicit inline MatchPatternSetOrStringSequence()
    : mType(eUninitialized)
  {
  }

  inline ~MatchPatternSetOrStringSequence()
  {
    Uninit();
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  RawSetAsMatchPatternSet()
  {
    if (mType == eMatchPatternSet) {
      return mValue.mMatchPatternSet.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMatchPatternSet;
    return mValue.mMatchPatternSet.SetValue();
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  SetAsMatchPatternSet()
  {
    if (mType == eMatchPatternSet) {
      return mValue.mMatchPatternSet.Value();
    }
    Uninit();
    mType = eMatchPatternSet;
    return mValue.mMatchPatternSet.SetValue();
  }

  inline bool
  IsMatchPatternSet() const
  {
    return mType == eMatchPatternSet;
  }

  inline NonNull<mozilla::extensions::MatchPatternSet>&
  GetAsMatchPatternSet()
  {
    MOZ_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline mozilla::extensions::MatchPatternSet&
  GetAsMatchPatternSet() const
  {
    MOZ_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline binding_detail::AutoSequence<nsString>&
  RawSetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline binding_detail::AutoSequence<nsString>&
  SetAsStringSequence()
  {
    if (mType == eStringSequence) {
      return mValue.mStringSequence.Value();
    }
    Uninit();
    mType = eStringSequence;
    return mValue.mStringSequence.SetValue();
  }

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline binding_detail::AutoSequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline const Sequence<nsString>&
  GetAsStringSequence() const
  {
    MOZ_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMatchPatternSet: {
        DestroyMatchPatternSet();
        break;
      }
      case eStringSequence: {
        DestroyStringSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyMatchPatternSet()
  {
    MOZ_ASSERT(IsMatchPatternSet(), "Wrong type!");
    mValue.mMatchPatternSet.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyStringSequence()
  {
    MOZ_ASSERT(IsStringSequence(), "Wrong type!");
    mValue.mStringSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningMatchPatternSetOrStringSequence : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMatchPatternSetOrStringSequence& aUnion);
  enum Type
  {
    eUninitialized,
    eMatchPatternSet,
    eStringSequence
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::extensions::MatchPatternSet> > mMatchPatternSet;
    UnionMember<Sequence<nsString> > mStringSequence;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningMatchPatternSetOrStringSequence()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningMatchPatternSetOrStringSequence(const OwningMatchPatternSetOrStringSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMatchPatternSetOrStringSequence()
  {
    Uninit();
  }

  OwningNonNull<mozilla::extensions::MatchPatternSet>&
  RawSetAsMatchPatternSet();

  OwningNonNull<mozilla::extensions::MatchPatternSet>&
  SetAsMatchPatternSet();

  bool
  TrySetToMatchPatternSet(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMatchPatternSet(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMatchPatternSet() const
  {
    return mType == eMatchPatternSet;
  }

  inline OwningNonNull<mozilla::extensions::MatchPatternSet>&
  GetAsMatchPatternSet()
  {
    MOZ_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  inline OwningNonNull<mozilla::extensions::MatchPatternSet> const &
  GetAsMatchPatternSet() const
  {
    MOZ_ASSERT(IsMatchPatternSet(), "Wrong type!");
    return mValue.mMatchPatternSet.Value();
  }

  Sequence<nsString>&
  RawSetAsStringSequence();

  Sequence<nsString>&
  SetAsStringSequence();

  bool
  TrySetToStringSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStringSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsStringSequence() const
  {
    return mType == eStringSequence;
  }

  inline Sequence<nsString>&
  GetAsStringSequence()
  {
    MOZ_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  inline Sequence<nsString> const &
  GetAsStringSequence() const
  {
    MOZ_ASSERT(IsStringSequence(), "Wrong type!");
    return mValue.mStringSequence.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMatchPatternSetOrStringSequence&
  operator=(const OwningMatchPatternSetOrStringSequence& aOther);

private:
  void
  DestroyMatchPatternSet();

  void
  DestroyStringSequence();
};


struct MozDocumentMatcherInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAllFrames;
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<OwningMatchGlobOrString>> mExcludeGlobs;
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningMatchPatternSetOrStringSequence > mExcludeMatches;
  MOZ_INIT_OUTSIDE_CTOR Nullable<uint64_t> mFrameID;
  MOZ_INIT_OUTSIDE_CTOR bool mHasActiveTabPermission;
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<OwningMatchGlobOrString>> mIncludeGlobs;
  MOZ_INIT_OUTSIDE_CTOR bool mMatchAboutBlank;
  MOZ_INIT_OUTSIDE_CTOR OwningMatchPatternSetOrStringSequence mMatches;

  MozDocumentMatcherInit();

  explicit inline MozDocumentMatcherInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozDocumentMatcherInit(const MozDocumentMatcherInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mExcludeGlobs, "mExcludeGlobs", aFlags);
    ImplCycleCollectionTraverse(aCallback, mExcludeMatches, "mExcludeMatches", aFlags);
    ImplCycleCollectionTraverse(aCallback, mIncludeGlobs, "mIncludeGlobs", aFlags);
    ImplCycleCollectionTraverse(aCallback, mMatches, "mMatches", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mExcludeGlobs);
    ImplCycleCollectionUnlink(mExcludeMatches);
    ImplCycleCollectionUnlink(mIncludeGlobs);
    ImplCycleCollectionUnlink(mMatches);
  }

  MozDocumentMatcherInit&
  operator=(const MozDocumentMatcherInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozDocumentMatcherInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozDocumentMatcherInit : public MozDocumentMatcherInit
{
  inline FastMozDocumentMatcherInit()
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WebExtensionContentScriptInit : public MozDocumentMatcherInit
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mCssPaths;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mJsPaths;
  MOZ_INIT_OUTSIDE_CTOR ContentScriptRunAt mRunAt;

  WebExtensionContentScriptInit();

  explicit inline WebExtensionContentScriptInit(const FastDictionaryInitializer& )
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline WebExtensionContentScriptInit(const WebExtensionContentScriptInit& aOther)
    : MozDocumentMatcherInit(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    MozDocumentMatcherInit::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    MozDocumentMatcherInit::UnlinkForCC();
  }

  WebExtensionContentScriptInit&
  operator=(const WebExtensionContentScriptInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, WebExtensionContentScriptInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastWebExtensionContentScriptInit : public WebExtensionContentScriptInit
{
  inline FastWebExtensionContentScriptInit()
    : WebExtensionContentScriptInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MozDocumentMatcher_Binding {

  typedef mozilla::extensions::MozDocumentMatcher NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::extensions::MozDocumentMatcher* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MozDocumentMatcher,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozDocumentMatcher,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MozDocumentMatcher_Binding



namespace WebExtensionContentScript_Binding {

  typedef mozilla::extensions::WebExtensionContentScript NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::extensions::WebExtensionContentScript* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebExtensionContentScript,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::WebExtensionContentScript,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace WebExtensionContentScript_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WebExtensionContentScriptBinding_h
