/* THIS FILE IS AUTOGENERATED FROM VTTCue.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_VTTCueBinding_h
#define mozilla_dom_VTTCueBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;
class TextTrackCue;
struct TextTrackCueAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class AutoKeyword : uint8_t {
  Auto,
  EndGuard_
};

namespace AutoKeywordValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(AutoKeyword::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(AutoKeyword stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace AutoKeywordValues

bool
ToJSValue(JSContext* aCx, AutoKeyword aArgument, JS::MutableHandle<JS::Value> aValue);


enum class LineAlignSetting : uint8_t {
  Start,
  Center,
  End,
  EndGuard_
};

namespace LineAlignSettingValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(LineAlignSetting::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(LineAlignSetting stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace LineAlignSettingValues

bool
ToJSValue(JSContext* aCx, LineAlignSetting aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PositionAlignSetting : uint8_t {
  Line_left,
  Center,
  Line_right,
  Auto,
  EndGuard_
};

namespace PositionAlignSettingValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PositionAlignSetting::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(PositionAlignSetting stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace PositionAlignSettingValues

bool
ToJSValue(JSContext* aCx, PositionAlignSetting aArgument, JS::MutableHandle<JS::Value> aValue);


enum class AlignSetting : uint8_t {
  Start,
  Center,
  End,
  Left,
  Right,
  EndGuard_
};

namespace AlignSettingValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(AlignSetting::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(AlignSetting stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace AlignSettingValues

bool
ToJSValue(JSContext* aCx, AlignSetting aArgument, JS::MutableHandle<JS::Value> aValue);


enum class DirectionSetting : uint8_t {
  _empty,
  Rl,
  Lr,
  EndGuard_
};

namespace DirectionSettingValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(DirectionSetting::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(DirectionSetting stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace DirectionSettingValues

bool
ToJSValue(JSContext* aCx, DirectionSetting aArgument, JS::MutableHandle<JS::Value> aValue);


class DoubleOrAutoKeyword
{
  friend class DoubleOrAutoKeywordArgument;
  enum Type
  {
    eUninitialized,
    eDouble,
    eAutoKeyword
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<AutoKeyword > mAutoKeyword;

  };

  Type mType;
  Value mValue;

  DoubleOrAutoKeyword(const DoubleOrAutoKeyword&) = delete;
  DoubleOrAutoKeyword& operator=(const DoubleOrAutoKeyword&) = delete;
public:
  explicit inline DoubleOrAutoKeyword()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrAutoKeyword()
  {
    Uninit();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline AutoKeyword&
  RawSetAsAutoKeyword()
  {
    if (mType == eAutoKeyword) {
      return mValue.mAutoKeyword.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eAutoKeyword;
    return mValue.mAutoKeyword.SetValue();
  }

  inline AutoKeyword&
  SetAsAutoKeyword()
  {
    if (mType == eAutoKeyword) {
      return mValue.mAutoKeyword.Value();
    }
    Uninit();
    mType = eAutoKeyword;
    return mValue.mAutoKeyword.SetValue();
  }

  inline bool
  IsAutoKeyword() const
  {
    return mType == eAutoKeyword;
  }

  inline AutoKeyword&
  GetAsAutoKeyword()
  {
    MOZ_ASSERT(IsAutoKeyword(), "Wrong type!");
    return mValue.mAutoKeyword.Value();
  }

  inline AutoKeyword
  GetAsAutoKeyword() const
  {
    MOZ_ASSERT(IsAutoKeyword(), "Wrong type!");
    return mValue.mAutoKeyword.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eAutoKeyword: {
        DestroyAutoKeyword();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyAutoKeyword()
  {
    MOZ_ASSERT(IsAutoKeyword(), "Wrong type!");
    mValue.mAutoKeyword.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleOrAutoKeyword : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDoubleOrAutoKeyword& aUnion);
  enum Type
  {
    eUninitialized,
    eDouble,
    eAutoKeyword
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<AutoKeyword > mAutoKeyword;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrAutoKeyword()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningDoubleOrAutoKeyword(const OwningDoubleOrAutoKeyword& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrAutoKeyword()
  {
    Uninit();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  AutoKeyword&
  RawSetAsAutoKeyword();

  AutoKeyword&
  SetAsAutoKeyword();

  bool
  TrySetToAutoKeyword(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToAutoKeyword(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsAutoKeyword() const
  {
    return mType == eAutoKeyword;
  }

  inline AutoKeyword&
  GetAsAutoKeyword()
  {
    MOZ_ASSERT(IsAutoKeyword(), "Wrong type!");
    return mValue.mAutoKeyword.Value();
  }

  inline AutoKeyword const &
  GetAsAutoKeyword() const
  {
    MOZ_ASSERT(IsAutoKeyword(), "Wrong type!");
    return mValue.mAutoKeyword.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningDoubleOrAutoKeyword&
  operator=(const OwningDoubleOrAutoKeyword& aOther);

private:
  void
  DestroyDouble();

  void
  DestroyAutoKeyword();
};


namespace VTTCue_Binding {

  typedef mozilla::dom::TextTrackCue NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::TextTrackCue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::VTTCue,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::VTTCue,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace VTTCue_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_VTTCueBinding_h
