/* THIS FILE IS AUTOGENERATED FROM U2F.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_U2FBinding_h
#define mozilla_dom_U2FBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct RegisterRequestAtoms;
struct RegisterResponse;
struct RegisterResponseAtoms;
struct RegisteredKeyAtoms;
struct SignResponse;
struct SignResponseAtoms;
class U2F;
struct U2FAtoms;
struct U2FClientDataAtoms;
class U2FRegisterCallback;
class U2FSignCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class Transport : uint8_t {
  Bt,
  Ble,
  Nfc,
  Usb,
  EndGuard_
};

namespace TransportValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(Transport::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(Transport stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace TransportValues

bool
ToJSValue(JSContext* aCx, Transport aArgument, JS::MutableHandle<JS::Value> aValue);


struct RegisterRequest : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mChallenge;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mVersion;

  RegisterRequest();

  explicit inline RegisterRequest(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RegisterRequest(const RegisterRequest& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  RegisterRequest&
  operator=(const RegisterRequest& aOther);

  bool
  operator==(const RegisterRequest& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RegisterRequestAtoms* atomsCache);
};

namespace binding_detail {
struct FastRegisterRequest : public RegisterRequest
{
  inline FastRegisterRequest()
    : RegisterRequest(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RegisterResponse : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mClientData;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<uint16_t>> mErrorCode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mErrorMessage;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRegistrationData;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mVersion;

  RegisterResponse();

  explicit inline RegisterResponse(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RegisterResponse(const RegisterResponse& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RegisterResponse&
  operator=(const RegisterResponse& aOther);

  bool
  operator==(const RegisterResponse& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, RegisterResponseAtoms* atomsCache);
};

namespace binding_detail {
struct FastRegisterResponse : public RegisterResponse
{
  inline FastRegisterResponse()
    : RegisterResponse(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RegisteredKey : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mAppId;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mKeyHandle;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<Sequence<Transport>>> mTransports;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mVersion;

  RegisteredKey();

  explicit inline RegisteredKey(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RegisteredKey(const RegisteredKey& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  RegisteredKey&
  operator=(const RegisteredKey& aOther);

private:
  static bool
  InitIds(JSContext* cx, RegisteredKeyAtoms* atomsCache);
};

namespace binding_detail {
struct FastRegisteredKey : public RegisteredKey
{
  inline FastRegisteredKey()
    : RegisteredKey(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SignResponse : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mClientData;
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<uint16_t>> mErrorCode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mErrorMessage;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mKeyHandle;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mSignatureData;

  SignResponse();

  explicit inline SignResponse(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline SignResponse(const SignResponse& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SignResponse&
  operator=(const SignResponse& aOther);

  bool
  operator==(const SignResponse& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, SignResponseAtoms* atomsCache);
};

namespace binding_detail {
struct FastSignResponse : public SignResponse
{
  inline FastSignResponse()
    : SignResponse(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct U2FClientData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mChallenge;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mOrigin;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTyp;

  U2FClientData();

  explicit inline U2FClientData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline U2FClientData(const U2FClientData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  U2FClientData&
  operator=(const U2FClientData& aOther);

  bool
  operator==(const U2FClientData& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, U2FClientDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastU2FClientData : public U2FClientData
{
  inline FastU2FClientData()
    : U2FClientData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class U2FRegisterCallback : public CallbackFunction
{
public:
  explicit inline U2FRegisterCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FRegisterCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FRegisterCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FRegisterCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const RegisterResponse& response, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "U2FRegisterCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, response, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const RegisterResponse& response, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "U2FRegisterCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, response, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const RegisterResponse& response, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, response, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const RegisterResponse& response, const char* aExecutionReason = nullptr)
  {
    return Call(response, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const U2FRegisterCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const RegisterResponse& response, ErrorResult& aRv);
};


class U2FSignCallback : public CallbackFunction
{
public:
  explicit inline U2FSignCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FSignCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FSignCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline U2FSignCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const SignResponse& response, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "U2FSignCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, response, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const SignResponse& response, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "U2FSignCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, response, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const SignResponse& response, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, response, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const SignResponse& response, const char* aExecutionReason = nullptr)
  {
    return Call(response, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const U2FSignCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const SignResponse& response, ErrorResult& aRv);
};


namespace binding_detail {
class FastU2FRegisterCallback : public U2FRegisterCallback
{
public:
  explicit inline FastU2FRegisterCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : U2FRegisterCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    U2FRegisterCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    U2FRegisterCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastU2FSignCallback : public U2FSignCallback
{
public:
  explicit inline FastU2FSignCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : U2FSignCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    U2FSignCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    U2FSignCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace U2F_Binding {

  typedef mozilla::dom::U2F NativeType;

  static const uint16_t OK = 0;
  static const uint16_t OTHER_ERROR = 1;
  static const uint16_t BAD_REQUEST = 2;
  static const uint16_t CONFIGURATION_UNSUPPORTED = 3;
  static const uint16_t DEVICE_INELIGIBLE = 4;
  static const uint16_t TIMEOUT = 5;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::U2F* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  ClearCachedRegisterValue(mozilla::dom::U2F* aObject);

  void
  ClearCachedSignValue(mozilla::dom::U2F* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::U2F,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::U2F,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace U2F_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_U2FBinding_h
