/* THIS FILE IS AUTOGENERATED FROM SharedWorker.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_SharedWorkerBinding_h
#define mozilla_dom_SharedWorkerBinding_h

#include "GeckoProfiler.h"
#include "WorkerBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;
class SharedWorker;
struct SharedWorkerAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

class StringOrWorkerOptions
{
  friend class StringOrWorkerOptionsArgument;
  enum Type
  {
    eUninitialized,
    eString,
    eWorkerOptions
  };

  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastWorkerOptions > mWorkerOptions;

  };

  Type mType;
  Value mValue;

  StringOrWorkerOptions(const StringOrWorkerOptions&) = delete;
  StringOrWorkerOptions& operator=(const StringOrWorkerOptions&) = delete;
public:
  explicit inline StringOrWorkerOptions()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrWorkerOptions()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline binding_detail::FastWorkerOptions&
  RawSetAsWorkerOptions()
  {
    if (mType == eWorkerOptions) {
      return mValue.mWorkerOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWorkerOptions;
    return mValue.mWorkerOptions.SetValue();
  }

  inline binding_detail::FastWorkerOptions&
  SetAsWorkerOptions()
  {
    if (mType == eWorkerOptions) {
      return mValue.mWorkerOptions.Value();
    }
    Uninit();
    mType = eWorkerOptions;
    return mValue.mWorkerOptions.SetValue();
  }

  inline bool
  IsWorkerOptions() const
  {
    return mType == eWorkerOptions;
  }

  inline binding_detail::FastWorkerOptions&
  GetAsWorkerOptions()
  {
    MOZ_ASSERT(IsWorkerOptions(), "Wrong type!");
    return mValue.mWorkerOptions.Value();
  }

  inline const WorkerOptions&
  GetAsWorkerOptions() const
  {
    MOZ_ASSERT(IsWorkerOptions(), "Wrong type!");
    return mValue.mWorkerOptions.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eWorkerOptions: {
        DestroyWorkerOptions();
        break;
      }
    }
  }

private:
  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyWorkerOptions()
  {
    MOZ_ASSERT(IsWorkerOptions(), "Wrong type!");
    mValue.mWorkerOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrWorkerOptions : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrWorkerOptions& aUnion);
  enum Type
  {
    eUninitialized,
    eString,
    eWorkerOptions
  };

  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<WorkerOptions > mWorkerOptions;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningStringOrWorkerOptions()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningStringOrWorkerOptions(const OwningStringOrWorkerOptions& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrWorkerOptions()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  WorkerOptions&
  RawSetAsWorkerOptions();

  WorkerOptions&
  SetAsWorkerOptions();

  bool
  TrySetToWorkerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWorkerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWorkerOptions() const
  {
    return mType == eWorkerOptions;
  }

  inline WorkerOptions&
  GetAsWorkerOptions()
  {
    MOZ_ASSERT(IsWorkerOptions(), "Wrong type!");
    return mValue.mWorkerOptions.Value();
  }

  inline WorkerOptions const &
  GetAsWorkerOptions() const
  {
    MOZ_ASSERT(IsWorkerOptions(), "Wrong type!");
    return mValue.mWorkerOptions.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrWorkerOptions&
  operator=(const OwningStringOrWorkerOptions& aOther);

private:
  void
  DestroyString();

  void
  DestroyWorkerOptions();
};


namespace SharedWorker_Binding {

  typedef mozilla::dom::SharedWorker NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::SharedWorker* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::SharedWorker,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::SharedWorker,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace SharedWorker_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SharedWorkerBinding_h
