/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SecurityPolicyViolationEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_SecurityPolicyViolationEvent_h
#define mozilla_dom_SecurityPolicyViolationEvent_h

#include "SecurityPolicyViolationEventBinding.h"
#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/SecurityPolicyViolationEventBinding.h"

struct JSContext;
namespace mozilla {
namespace dom {

class SecurityPolicyViolationEvent : public Event
{
public:
  NS_INLINE_DECL_REFCOUNTING_INHERITED(SecurityPolicyViolationEvent, Event)

protected:
  virtual ~SecurityPolicyViolationEvent();
  explicit SecurityPolicyViolationEvent(mozilla::dom::EventTarget* aOwner);

  nsString mDocumentURI;
  nsString mReferrer;
  nsString mBlockedURI;
  nsString mViolatedDirective;
  nsString mEffectiveDirective;
  nsString mOriginalPolicy;
  nsString mSourceFile;
  nsString mSample;
  SecurityPolicyViolationEventDisposition mDisposition;
  uint16_t mStatusCode;
  int32_t mLineNumber;
  int32_t mColumnNumber;

public:
  SecurityPolicyViolationEvent* AsSecurityPolicyViolationEvent() override;

  JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<SecurityPolicyViolationEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SecurityPolicyViolationEventInit& aEventInitDict);

  static already_AddRefed<SecurityPolicyViolationEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SecurityPolicyViolationEventInit& aEventInitDict);

  void GetDocumentURI(nsString& aRetVal) const;

  void GetReferrer(nsString& aRetVal) const;

  void GetBlockedURI(nsString& aRetVal) const;

  void GetViolatedDirective(nsString& aRetVal) const;

  void GetEffectiveDirective(nsString& aRetVal) const;

  void GetOriginalPolicy(nsString& aRetVal) const;

  void GetSourceFile(nsString& aRetVal) const;

  void GetSample(nsString& aRetVal) const;

  SecurityPolicyViolationEventDisposition Disposition() const;

  uint16_t StatusCode() const;

  int32_t LineNumber() const;

  int32_t ColumnNumber() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SecurityPolicyViolationEvent_h
