/* THIS FILE IS AUTOGENERATED FROM RTCSessionDescription.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RTCSessionDescriptionBinding_h
#define mozilla_dom_RTCSessionDescriptionBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;
class RTCSessionDescription;
struct RTCSessionDescriptionAtoms;
struct RTCSessionDescriptionInit;
struct RTCSessionDescriptionInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RTCSdpType : uint8_t {
  Offer,
  Pranswer,
  Answer,
  Rollback,
  EndGuard_
};

namespace RTCSdpTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCSdpType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RTCSdpType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RTCSdpTypeValues

bool
ToJSValue(JSContext* aCx, RTCSdpType aArgument, JS::MutableHandle<JS::Value> aValue);


struct RTCSessionDescriptionInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mSdp;
  MOZ_INIT_OUTSIDE_CTOR Optional<RTCSdpType> mType;

  RTCSessionDescriptionInit();

  explicit inline RTCSessionDescriptionInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCSessionDescriptionInit(const RTCSessionDescriptionInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCSessionDescriptionInit&
  operator=(const RTCSessionDescriptionInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCSessionDescriptionInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCSessionDescriptionInit : public RTCSessionDescriptionInit
{
  inline FastRTCSessionDescriptionInit()
    : RTCSessionDescriptionInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace RTCSessionDescription_Binding {

  typedef mozilla::dom::RTCSessionDescription NativeType;

  MOZ_CAN_RUN_SCRIPT bool
  CollectJSONAttributes(JSContext* cx, JS::Handle<JSObject*> obj, mozilla::dom::RTCSessionDescription* self, JS::Rooted<JSObject*>& result);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::RTCSessionDescription* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCSessionDescription,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCSessionDescription,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace RTCSessionDescription_Binding



class RTCSessionDescriptionJSImpl : public CallbackInterface
{
public:
  explicit inline RTCSessionDescriptionJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline RTCSessionDescriptionJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline RTCSessionDescriptionJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  void ToJSON(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void __Init(const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const RTCSessionDescriptionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  RTCSdpType GetType(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetSdp(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetType(RTCSdpType arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void SetSdp(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

private:
  static bool
  InitIds(JSContext* cx, RTCSessionDescriptionAtoms* atomsCache);
};


class RTCSessionDescription : public nsSupportsWeakReference,
                              public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(RTCSessionDescription)

private:
  RefPtr<RTCSessionDescriptionJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  RTCSessionDescription(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

protected:
  virtual ~RTCSessionDescription();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<RTCSessionDescription> Constructor(const GlobalObject& global, JSContext* cx, const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto = nullptr);

  RTCSdpType GetType(ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetType(RTCSdpType arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void GetSdp(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr) const;

  void SetSdp(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  void ToJSON(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCSessionDescriptionBinding_h
