/* THIS FILE IS AUTOGENERATED FROM Permissions.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_PermissionsBinding_h
#define mozilla_dom_PermissionsBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
struct PermissionDescriptorAtoms;
class Permissions;
struct PermissionsAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class PermissionName : uint8_t {
  Geolocation,
  Notifications,
  Push,
  Persistent_storage,
  EndGuard_
};

namespace PermissionNameValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PermissionName::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(PermissionName stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace PermissionNameValues

bool
ToJSValue(JSContext* aCx, PermissionName aArgument, JS::MutableHandle<JS::Value> aValue);


struct PermissionDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR PermissionName mName;

  PermissionDescriptor();

  explicit inline PermissionDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PermissionDescriptor(const PermissionDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PermissionDescriptor&
  operator=(const PermissionDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, PermissionDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastPermissionDescriptor : public PermissionDescriptor
{
  inline FastPermissionDescriptor()
    : PermissionDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Permissions_Binding {

  typedef mozilla::dom::Permissions NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Permissions* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Permissions,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Permissions,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Permissions_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PermissionsBinding_h
