/* THIS FILE IS AUTOGENERATED FROM PaymentRequest.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_PaymentRequestBinding_h
#define mozilla_dom_PaymentRequestBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct AddressErrors;
struct AddressErrorsAtoms;
struct NativePropertyHooks;
struct PayerErrors;
struct PayerErrorsAtoms;
struct PaymentCurrencyAmount;
struct PaymentCurrencyAmountAtoms;
struct PaymentDetailsBaseAtoms;
struct PaymentDetailsInitAtoms;
struct PaymentDetailsModifier;
struct PaymentDetailsModifierAtoms;
struct PaymentDetailsUpdateAtoms;
struct PaymentItem;
struct PaymentItemAtoms;
struct PaymentMethodDataAtoms;
struct PaymentOptionsAtoms;
class PaymentRequest;
struct PaymentRequestAtoms;
struct PaymentShippingOption;
struct PaymentShippingOptionAtoms;
struct PaymentValidationErrorsAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class PaymentShippingType : uint8_t {
  Shipping,
  Delivery,
  Pickup,
  EndGuard_
};

namespace PaymentShippingTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PaymentShippingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(PaymentShippingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace PaymentShippingTypeValues

bool
ToJSValue(JSContext* aCx, PaymentShippingType aArgument, JS::MutableHandle<JS::Value> aValue);


struct AddressErrors : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mAddressLine;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mCity;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mCountry;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mDependentLocality;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mOrganization;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPhone;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPostalCode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRecipient;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRegion;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mRegionCode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mSortingCode;

  AddressErrors();

  explicit inline AddressErrors(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline AddressErrors(const AddressErrors& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  AddressErrors&
  operator=(const AddressErrors& aOther);

  bool
  operator==(const AddressErrors& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, AddressErrorsAtoms* atomsCache);
};

namespace binding_detail {
struct FastAddressErrors : public AddressErrors
{
  inline FastAddressErrors()
    : AddressErrors(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PayerErrors : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mEmail;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mName;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPhone;

  PayerErrors();

  explicit inline PayerErrors(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PayerErrors(const PayerErrors& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  PayerErrors&
  operator=(const PayerErrors& aOther);

  bool
  operator==(const PayerErrors& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PayerErrorsAtoms* atomsCache);
};

namespace binding_detail {
struct FastPayerErrors : public PayerErrors
{
  inline FastPayerErrors()
    : PayerErrors(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentCurrencyAmount : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCurrency;
  MOZ_INIT_OUTSIDE_CTOR nsString mValue;

  PaymentCurrencyAmount();

  explicit inline PaymentCurrencyAmount(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentCurrencyAmount(const PaymentCurrencyAmount& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PaymentCurrencyAmount&
  operator=(const PaymentCurrencyAmount& aOther);

  bool
  operator==(const PaymentCurrencyAmount& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PaymentCurrencyAmountAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentCurrencyAmount : public PaymentCurrencyAmount
{
  inline FastPaymentCurrencyAmount()
    : PaymentCurrencyAmount(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentMethodData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mData;
  MOZ_INIT_OUTSIDE_CTOR nsString mSupportedMethods;

  PaymentMethodData();

  explicit inline PaymentMethodData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentMethodData(const PaymentMethodData&) = delete;
  PaymentMethodData& operator=(const PaymentMethodData&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentMethodDataAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentMethodData : public PaymentMethodData
{
  inline FastPaymentMethodData()
    : PaymentMethodData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mRequestBillingAddress;
  MOZ_INIT_OUTSIDE_CTOR bool mRequestPayerEmail;
  MOZ_INIT_OUTSIDE_CTOR bool mRequestPayerName;
  MOZ_INIT_OUTSIDE_CTOR bool mRequestPayerPhone;
  MOZ_INIT_OUTSIDE_CTOR bool mRequestShipping;
  MOZ_INIT_OUTSIDE_CTOR PaymentShippingType mShippingType;

  PaymentOptions();

  explicit inline PaymentOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentOptions(const PaymentOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PaymentOptions&
  operator=(const PaymentOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, PaymentOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentOptions : public PaymentOptions
{
  inline FastPaymentOptions()
    : PaymentOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentItem : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR PaymentCurrencyAmount mAmount;
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;
  MOZ_INIT_OUTSIDE_CTOR bool mPending;

  PaymentItem();

  explicit inline PaymentItem(const FastDictionaryInitializer& )
    : mAmount(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentItem(const PaymentItem& aOther)
    : mAmount(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PaymentItem&
  operator=(const PaymentItem& aOther);

private:
  static bool
  InitIds(JSContext* cx, PaymentItemAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentItem : public PaymentItem
{
  inline FastPaymentItem()
    : PaymentItem(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentShippingOption : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR PaymentCurrencyAmount mAmount;
  MOZ_INIT_OUTSIDE_CTOR nsString mId;
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;
  MOZ_INIT_OUTSIDE_CTOR bool mSelected;

  PaymentShippingOption();

  explicit inline PaymentShippingOption(const FastDictionaryInitializer& )
    : mAmount(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentShippingOption(const PaymentShippingOption& aOther)
    : mAmount(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  PaymentShippingOption&
  operator=(const PaymentShippingOption& aOther);

private:
  static bool
  InitIds(JSContext* cx, PaymentShippingOptionAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentShippingOption : public PaymentShippingOption
{
  inline FastPaymentShippingOption()
    : PaymentShippingOption(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentValidationErrors : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mError;
  MOZ_INIT_OUTSIDE_CTOR Optional<PayerErrors> mPayer;
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mPaymentMethod;
  MOZ_INIT_OUTSIDE_CTOR Optional<AddressErrors> mShippingAddress;

  PaymentValidationErrors();

  explicit inline PaymentValidationErrors(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentValidationErrors(const PaymentValidationErrors&) = delete;
  PaymentValidationErrors& operator=(const PaymentValidationErrors&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentValidationErrorsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentValidationErrors : public PaymentValidationErrors
{
  inline FastPaymentValidationErrors()
    : PaymentValidationErrors(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentDetailsModifier : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PaymentItem>> mAdditionalDisplayItems;
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mData;
  MOZ_INIT_OUTSIDE_CTOR nsString mSupportedMethods;
  MOZ_INIT_OUTSIDE_CTOR Optional<PaymentItem> mTotal;

  PaymentDetailsModifier();

  explicit inline PaymentDetailsModifier(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentDetailsModifier(const PaymentDetailsModifier&) = delete;
  PaymentDetailsModifier& operator=(const PaymentDetailsModifier&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentDetailsModifierAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentDetailsModifier : public PaymentDetailsModifier
{
  inline FastPaymentDetailsModifier()
    : PaymentDetailsModifier(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentDetailsBase : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PaymentItem>> mDisplayItems;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PaymentDetailsModifier>> mModifiers;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<PaymentShippingOption>> mShippingOptions;

  PaymentDetailsBase();

  explicit inline PaymentDetailsBase(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentDetailsBase(const PaymentDetailsBase&) = delete;
  PaymentDetailsBase& operator=(const PaymentDetailsBase&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentDetailsBaseAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentDetailsBase : public PaymentDetailsBase
{
  inline FastPaymentDetailsBase()
    : PaymentDetailsBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentDetailsInit : public PaymentDetailsBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mId;
  MOZ_INIT_OUTSIDE_CTOR PaymentItem mTotal;

  PaymentDetailsInit();

  explicit inline PaymentDetailsInit(const FastDictionaryInitializer& )
    : PaymentDetailsBase(FastDictionaryInitializer()),
      mTotal(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentDetailsInit(const PaymentDetailsInit&) = delete;
  PaymentDetailsInit& operator=(const PaymentDetailsInit&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentDetailsInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentDetailsInit : public PaymentDetailsInit
{
  inline FastPaymentDetailsInit()
    : PaymentDetailsInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentDetailsUpdate : public PaymentDetailsBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mError;
  MOZ_INIT_OUTSIDE_CTOR Optional<PayerErrors> mPayerErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mPaymentMethodErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<AddressErrors> mShippingAddressErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<PaymentItem> mTotal;

  PaymentDetailsUpdate();

  explicit inline PaymentDetailsUpdate(const FastDictionaryInitializer& )
    : PaymentDetailsBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PaymentDetailsUpdate(const PaymentDetailsUpdate&) = delete;
  PaymentDetailsUpdate& operator=(const PaymentDetailsUpdate&) = delete;

  static bool
  InitIds(JSContext* cx, PaymentDetailsUpdateAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPaymentDetailsUpdate : public PaymentDetailsUpdate
{
  inline FastPaymentDetailsUpdate()
    : PaymentDetailsUpdate(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace PaymentRequest_Binding {

  typedef mozilla::dom::PaymentRequest NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::PaymentRequest* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::PaymentRequest,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::PaymentRequest,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace PaymentRequest_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PaymentRequestBinding_h
