/* THIS FILE IS AUTOGENERATED FROM KeyframeEffect.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_KeyframeEffectBinding_h
#define mozilla_dom_KeyframeEffectBinding_h

#include "AnimationEffectBinding.h"
#include "BaseKeyframeTypesBinding.h"
#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct AnimationPropertyDetailsAtoms;
struct AnimationPropertyValueDetails;
struct AnimationPropertyValueDetailsAtoms;
class KeyframeEffect;
struct KeyframeEffectAtoms;
struct KeyframeEffectOptionsAtoms;
struct NativePropertyHooks;
class OwningUnrestrictedDoubleOrString;
class ProtoAndIfaceCache;
class UnrestrictedDoubleOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class IterationCompositeOperation : uint8_t {
  Replace,
  Accumulate,
  EndGuard_
};

namespace IterationCompositeOperationValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(IterationCompositeOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(IterationCompositeOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace IterationCompositeOperationValues

bool
ToJSValue(JSContext* aCx, IterationCompositeOperation aArgument, JS::MutableHandle<JS::Value> aValue);


struct AnimationPropertyValueDetails : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR CompositeOperation mComposite;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mEasing;
  MOZ_INIT_OUTSIDE_CTOR double mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mValue;

  AnimationPropertyValueDetails();

  explicit inline AnimationPropertyValueDetails(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline AnimationPropertyValueDetails(const AnimationPropertyValueDetails& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AnimationPropertyValueDetails&
  operator=(const AnimationPropertyValueDetails& aOther);

private:
  static bool
  InitIds(JSContext* cx, AnimationPropertyValueDetailsAtoms* atomsCache);
};

namespace binding_detail {
struct FastAnimationPropertyValueDetails : public AnimationPropertyValueDetails
{
  inline FastAnimationPropertyValueDetails()
    : AnimationPropertyValueDetails(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct KeyframeEffectOptions : public EffectTiming
{
  MOZ_INIT_OUTSIDE_CTOR CompositeOperation mComposite;
  MOZ_INIT_OUTSIDE_CTOR IterationCompositeOperation mIterationComposite;
  MOZ_INIT_OUTSIDE_CTOR nsString mPseudoElement;

  KeyframeEffectOptions();

  explicit inline KeyframeEffectOptions(const FastDictionaryInitializer& )
    : EffectTiming(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline KeyframeEffectOptions(const KeyframeEffectOptions& aOther)
    : EffectTiming(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  KeyframeEffectOptions&
  operator=(const KeyframeEffectOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, KeyframeEffectOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastKeyframeEffectOptions : public KeyframeEffectOptions
{
  inline FastKeyframeEffectOptions()
    : KeyframeEffectOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AnimationPropertyDetails : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mProperty;
  MOZ_INIT_OUTSIDE_CTOR bool mRunningOnCompositor;
  MOZ_INIT_OUTSIDE_CTOR Sequence<AnimationPropertyValueDetails> mValues;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mWarning;

  AnimationPropertyDetails();

  explicit inline AnimationPropertyDetails(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline AnimationPropertyDetails(const AnimationPropertyDetails& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AnimationPropertyDetails&
  operator=(const AnimationPropertyDetails& aOther);

private:
  static bool
  InitIds(JSContext* cx, AnimationPropertyDetailsAtoms* atomsCache);
};

namespace binding_detail {
struct FastAnimationPropertyDetails : public AnimationPropertyDetails
{
  inline FastAnimationPropertyDetails()
    : AnimationPropertyDetails(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UnrestrictedDoubleOrKeyframeEffectOptions
{
  friend class UnrestrictedDoubleOrKeyframeEffectOptionsArgument;
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eKeyframeEffectOptions
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FastKeyframeEffectOptions > mKeyframeEffectOptions;

  };

  Type mType;
  Value mValue;

  UnrestrictedDoubleOrKeyframeEffectOptions(const UnrestrictedDoubleOrKeyframeEffectOptions&) = delete;
  UnrestrictedDoubleOrKeyframeEffectOptions& operator=(const UnrestrictedDoubleOrKeyframeEffectOptions&) = delete;
public:
  explicit inline UnrestrictedDoubleOrKeyframeEffectOptions()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrKeyframeEffectOptions()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FastKeyframeEffectOptions&
  RawSetAsKeyframeEffectOptions()
  {
    if (mType == eKeyframeEffectOptions) {
      return mValue.mKeyframeEffectOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eKeyframeEffectOptions;
    return mValue.mKeyframeEffectOptions.SetValue();
  }

  inline binding_detail::FastKeyframeEffectOptions&
  SetAsKeyframeEffectOptions()
  {
    if (mType == eKeyframeEffectOptions) {
      return mValue.mKeyframeEffectOptions.Value();
    }
    Uninit();
    mType = eKeyframeEffectOptions;
    return mValue.mKeyframeEffectOptions.SetValue();
  }

  inline bool
  IsKeyframeEffectOptions() const
  {
    return mType == eKeyframeEffectOptions;
  }

  inline binding_detail::FastKeyframeEffectOptions&
  GetAsKeyframeEffectOptions()
  {
    MOZ_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
    return mValue.mKeyframeEffectOptions.Value();
  }

  inline const KeyframeEffectOptions&
  GetAsKeyframeEffectOptions() const
  {
    MOZ_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
    return mValue.mKeyframeEffectOptions.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eKeyframeEffectOptions: {
        DestroyKeyframeEffectOptions();
        break;
      }
    }
  }

private:
  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyKeyframeEffectOptions()
  {
    MOZ_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
    mValue.mKeyframeEffectOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnrestrictedDoubleOrKeyframeEffectOptions : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnrestrictedDoubleOrKeyframeEffectOptions& aUnion);
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eKeyframeEffectOptions
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<KeyframeEffectOptions > mKeyframeEffectOptions;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrKeyframeEffectOptions()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnrestrictedDoubleOrKeyframeEffectOptions(const OwningUnrestrictedDoubleOrKeyframeEffectOptions& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrKeyframeEffectOptions()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  KeyframeEffectOptions&
  RawSetAsKeyframeEffectOptions();

  KeyframeEffectOptions&
  SetAsKeyframeEffectOptions();

  bool
  TrySetToKeyframeEffectOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToKeyframeEffectOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsKeyframeEffectOptions() const
  {
    return mType == eKeyframeEffectOptions;
  }

  inline KeyframeEffectOptions&
  GetAsKeyframeEffectOptions()
  {
    MOZ_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
    return mValue.mKeyframeEffectOptions.Value();
  }

  inline KeyframeEffectOptions const &
  GetAsKeyframeEffectOptions() const
  {
    MOZ_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
    return mValue.mKeyframeEffectOptions.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningUnrestrictedDoubleOrKeyframeEffectOptions&
  operator=(const OwningUnrestrictedDoubleOrKeyframeEffectOptions& aOther);

private:
  void
  DestroyUnrestrictedDouble();

  void
  DestroyKeyframeEffectOptions();
};


namespace KeyframeEffect_Binding {

  typedef mozilla::dom::KeyframeEffect NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::KeyframeEffect* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::KeyframeEffect,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::KeyframeEffect,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace KeyframeEffect_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_KeyframeEffectBinding_h
