/* THIS FILE IS AUTOGENERATED FROM InstallTrigger.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_InstallTriggerBinding_h
#define mozilla_dom_InstallTriggerBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class InstallTriggerCallback;
struct InstallTriggerDataAtoms;
class InstallTriggerImpl;
struct InstallTriggerImplAtoms;
struct NativePropertyHooks;
class OwningStringOrInstallTriggerData;
class ProtoAndIfaceCache;
class StringOrInstallTriggerData;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct InstallTriggerData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mHash;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIconURL;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mURL;

  InstallTriggerData();

  explicit inline InstallTriggerData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline InstallTriggerData(const InstallTriggerData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InstallTriggerData&
  operator=(const InstallTriggerData& aOther);

  bool
  operator==(const InstallTriggerData& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInstallTriggerData : public InstallTriggerData
{
  inline FastInstallTriggerData()
    : InstallTriggerData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrInstallTriggerData
{
  friend class StringOrInstallTriggerDataArgument;
  enum Type
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };

  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastInstallTriggerData > mInstallTriggerData;

  };

  Type mType;
  Value mValue;

  StringOrInstallTriggerData(const StringOrInstallTriggerData&) = delete;
  StringOrInstallTriggerData& operator=(const StringOrInstallTriggerData&) = delete;
public:
  explicit inline StringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrInstallTriggerData()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline binding_detail::FastInstallTriggerData&
  RawSetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  inline binding_detail::FastInstallTriggerData&
  SetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    Uninit();
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline binding_detail::FastInstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline const InstallTriggerData&
  GetAsInstallTriggerData() const
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eInstallTriggerData: {
        DestroyInstallTriggerData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    mValue.mInstallTriggerData.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrInstallTriggerData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrInstallTriggerData& aUnion);
  enum Type
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };

  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<InstallTriggerData > mInstallTriggerData;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningStringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningStringOrInstallTriggerData(const OwningStringOrInstallTriggerData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrInstallTriggerData()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  InstallTriggerData&
  RawSetAsInstallTriggerData();

  InstallTriggerData&
  SetAsInstallTriggerData();

  bool
  TrySetToInstallTriggerData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInstallTriggerData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline InstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline InstallTriggerData const &
  GetAsInstallTriggerData() const
  {
    MOZ_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrInstallTriggerData&
  operator=(const OwningStringOrInstallTriggerData& aOther);

private:
  void
  DestroyString();

  void
  DestroyInstallTriggerData();
};


class InstallTriggerCallback : public CallbackFunction
{
public:
  explicit inline InstallTriggerCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& url, int16_t status, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "InstallTriggerCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, url, status, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& url, int16_t status, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "InstallTriggerCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, url, status, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& url, int16_t status, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, url, status, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& url, int16_t status, const char* aExecutionReason = nullptr)
  {
    return Call(url, status, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const InstallTriggerCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& url, int16_t status, ErrorResult& aRv);
};


namespace binding_detail {
class FastInstallTriggerCallback : public InstallTriggerCallback
{
public:
  explicit inline FastInstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : InstallTriggerCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    InstallTriggerCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    InstallTriggerCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace InstallTriggerImpl_Binding {

  typedef mozilla::dom::InstallTriggerImpl NativeType;

  static const uint16_t SKIN = 1;
  static const uint16_t LOCALE = 2;
  static const uint16_t CONTENT = 4;
  static const uint16_t PACKAGE = 7;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::InstallTriggerImpl* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::InstallTriggerImpl,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::InstallTriggerImpl,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace InstallTriggerImpl_Binding



class InstallTriggerImplJSImpl : public CallbackInterface
{
public:
  explicit inline InstallTriggerImplJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline InstallTriggerImplJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline InstallTriggerImplJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  bool Enabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const InstallTriggerImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerImplAtoms* atomsCache);
};


class InstallTriggerImpl final : public nsSupportsWeakReference,
                                 public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(InstallTriggerImpl)

private:
  RefPtr<InstallTriggerImplJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  InstallTriggerImpl(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~InstallTriggerImpl();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  bool Enabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InstallTriggerBinding_h
