/* THIS FILE IS AUTOGENERATED FROM ImageBitmap.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ImageBitmapBinding_h
#define mozilla_dom_ImageBitmapBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
class CanvasRenderingContext2D;
struct ChannelPixelLayoutAtoms;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
struct ImageBitmapAtoms;
class ImageData;
struct NativePropertyHooks;
class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData;
class ProtoAndIfaceCache;
class SVGImageElement;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class ImageBitmapFormat : uint8_t {
  RGBA32,
  BGRA32,
  RGB24,
  BGR24,
  GRAY8,
  YUV444P,
  YUV422P,
  YUV420P,
  YUV420SP_NV12,
  YUV420SP_NV21,
  HSV,
  Lab,
  DEPTH,
  EndGuard_
};

namespace ImageBitmapFormatValues {
extern const EnumEntry strings[14];

static constexpr size_t Count = 13;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ImageBitmapFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(ImageBitmapFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace ImageBitmapFormatValues

bool
ToJSValue(JSContext* aCx, ImageBitmapFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ChannelPixelLayoutDataType : uint8_t {
  Uint8,
  Int8,
  Uint16,
  Int16,
  Uint32,
  Int32,
  Float32,
  Float64,
  EndGuard_
};

namespace ChannelPixelLayoutDataTypeValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ChannelPixelLayoutDataType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(ChannelPixelLayoutDataType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace ChannelPixelLayoutDataTypeValues

bool
ToJSValue(JSContext* aCx, ChannelPixelLayoutDataType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);


struct ChannelPixelLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ChannelPixelLayoutDataType mDataType;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSkip;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStride;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  ChannelPixelLayout();

  explicit inline ChannelPixelLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ChannelPixelLayout(const ChannelPixelLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ChannelPixelLayout&
  operator=(const ChannelPixelLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChannelPixelLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastChannelPixelLayout : public ChannelPixelLayout
{
  inline FastChannelPixelLayout()
    : ChannelPixelLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData
{
  friend class HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageDataArgument;
  enum Type
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eImageBitmap,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<NonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<NonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<NonNull<mozilla::dom::ImageData> > mImageData;

  };

  Type mType;
  Value mValue;

  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& operator=(const HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&) = delete;
public:
  explicit inline HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  inline ~HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    Uninit();
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline mozilla::dom::HTMLImageElement&
  GetAsHTMLImageElement() const
  {
    MOZ_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement()
  {
    if (mType == eSVGImageElement) {
      return mValue.mSVGImageElement.Value();
    }
    Uninit();
    mType = eSVGImageElement;
    return mValue.mSVGImageElement.SetValue();
  }

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline NonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline mozilla::dom::SVGImageElement&
  GetAsSVGImageElement() const
  {
    MOZ_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement()
  {
    if (mType == eHTMLVideoElement) {
      return mValue.mHTMLVideoElement.Value();
    }
    Uninit();
    mType = eHTMLVideoElement;
    return mValue.mHTMLVideoElement.SetValue();
  }

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline NonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline mozilla::dom::HTMLVideoElement&
  GetAsHTMLVideoElement() const
  {
    MOZ_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D()
  {
    if (mType == eCanvasRenderingContext2D) {
      return mValue.mCanvasRenderingContext2D.Value();
    }
    Uninit();
    mType = eCanvasRenderingContext2D;
    return mValue.mCanvasRenderingContext2D.SetValue();
  }

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline NonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline mozilla::dom::CanvasRenderingContext2D&
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline NonNull<mozilla::dom::ImageData>&
  RawSetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  inline NonNull<mozilla::dom::ImageData>&
  SetAsImageData()
  {
    if (mType == eImageData) {
      return mValue.mImageData.Value();
    }
    Uninit();
    mType = eImageData;
    return mValue.mImageData.SetValue();
  }

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline NonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline mozilla::dom::ImageData&
  GetAsImageData() const
  {
    MOZ_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eHTMLImageElement: {
        DestroyHTMLImageElement();
        break;
      }
      case eSVGImageElement: {
        DestroySVGImageElement();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eHTMLVideoElement: {
        DestroyHTMLVideoElement();
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eCanvasRenderingContext2D: {
        DestroyCanvasRenderingContext2D();
        break;
      }
      case eImageData: {
        DestroyImageData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyHTMLImageElement()
  {
    MOZ_ASSERT(IsHTMLImageElement(), "Wrong type!");
    mValue.mHTMLImageElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroySVGImageElement()
  {
    MOZ_ASSERT(IsSVGImageElement(), "Wrong type!");
    mValue.mSVGImageElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyHTMLVideoElement()
  {
    MOZ_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    mValue.mHTMLVideoElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyImageBitmap()
  {
    MOZ_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyCanvasRenderingContext2D()
  {
    MOZ_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    mValue.mCanvasRenderingContext2D.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyImageData()
  {
    MOZ_ASSERT(IsImageData(), "Wrong type!");
    mValue.mImageData.Destroy();
    mType = eUninitialized;
  }
};


class OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aUnion);
  enum Type
  {
    eUninitialized,
    eHTMLImageElement,
    eSVGImageElement,
    eHTMLCanvasElement,
    eHTMLVideoElement,
    eImageBitmap,
    eBlob,
    eCanvasRenderingContext2D,
    eImageData
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<OwningNonNull<mozilla::dom::SVGImageElement> > mSVGImageElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLVideoElement> > mHTMLVideoElement;
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<OwningNonNull<mozilla::dom::CanvasRenderingContext2D> > mCanvasRenderingContext2D;
    UnionMember<OwningNonNull<mozilla::dom::ImageData> > mImageData;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement();

  OwningNonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement();

  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement> const &
  GetAsHTMLImageElement() const
  {
    MOZ_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  OwningNonNull<mozilla::dom::SVGImageElement>&
  RawSetAsSVGImageElement();

  OwningNonNull<mozilla::dom::SVGImageElement>&
  SetAsSVGImageElement();

  bool
  TrySetToSVGImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSVGImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsSVGImageElement() const
  {
    return mType == eSVGImageElement;
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement>&
  GetAsSVGImageElement()
  {
    MOZ_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::SVGImageElement> const &
  GetAsSVGImageElement() const
  {
    MOZ_ASSERT(IsSVGImageElement(), "Wrong type!");
    return mValue.mSVGImageElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  RawSetAsHTMLVideoElement();

  OwningNonNull<mozilla::dom::HTMLVideoElement>&
  SetAsHTMLVideoElement();

  bool
  TrySetToHTMLVideoElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLVideoElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsHTMLVideoElement() const
  {
    return mType == eHTMLVideoElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement>&
  GetAsHTMLVideoElement()
  {
    MOZ_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLVideoElement> const &
  GetAsHTMLVideoElement() const
  {
    MOZ_ASSERT(IsHTMLVideoElement(), "Wrong type!");
    return mValue.mHTMLVideoElement.Value();
  }

  OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  RawSetAsCanvasRenderingContext2D();

  OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  SetAsCanvasRenderingContext2D();

  bool
  TrySetToCanvasRenderingContext2D(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCanvasRenderingContext2D(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsCanvasRenderingContext2D() const
  {
    return mType == eCanvasRenderingContext2D;
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D>&
  GetAsCanvasRenderingContext2D()
  {
    MOZ_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  inline OwningNonNull<mozilla::dom::CanvasRenderingContext2D> const &
  GetAsCanvasRenderingContext2D() const
  {
    MOZ_ASSERT(IsCanvasRenderingContext2D(), "Wrong type!");
    return mValue.mCanvasRenderingContext2D.Value();
  }

  OwningNonNull<mozilla::dom::ImageData>&
  RawSetAsImageData();

  OwningNonNull<mozilla::dom::ImageData>&
  SetAsImageData();

  bool
  TrySetToImageData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsImageData() const
  {
    return mType == eImageData;
  }

  inline OwningNonNull<mozilla::dom::ImageData>&
  GetAsImageData()
  {
    MOZ_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageData> const &
  GetAsImageData() const
  {
    MOZ_ASSERT(IsImageData(), "Wrong type!");
    return mValue.mImageData.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData&
  operator=(const OwningHTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrImageBitmapOrBlobOrCanvasRenderingContext2DOrImageData& aOther);

private:
  void
  DestroyHTMLImageElement();

  void
  DestroySVGImageElement();

  void
  DestroyHTMLCanvasElement();

  void
  DestroyHTMLVideoElement();

  void
  DestroyImageBitmap();

  void
  DestroyBlob();

  void
  DestroyCanvasRenderingContext2D();

  void
  DestroyImageData();
};


namespace ImageBitmap_Binding {

  typedef mozilla::dom::ImageBitmap NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageBitmap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ImageBitmap,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageBitmap,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace ImageBitmap_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ImageBitmapBinding_h
