/* THIS FILE IS AUTOGENERATED FROM GeometryUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_GeometryUtilsBinding_h
#define mozilla_dom_GeometryUtilsBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct BoxQuadOptionsAtoms;
struct ConvertCoordinateOptionsAtoms;
class Document;
class Element;
struct NativePropertyHooks;
class OwningTextOrElementOrDocument;
class ProtoAndIfaceCache;
class Text;
class TextOrElementOrDocument;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CSSBoxType : uint8_t {
  Margin,
  Border,
  Padding,
  Content,
  EndGuard_
};

namespace CSSBoxTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CSSBoxType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(CSSBoxType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace CSSBoxTypeValues

bool
ToJSValue(JSContext* aCx, CSSBoxType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTextOrElementOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);


struct ConvertCoordinateOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mFromBox;
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mToBox;

  ConvertCoordinateOptions();

  explicit inline ConvertCoordinateOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConvertCoordinateOptions(const ConvertCoordinateOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ConvertCoordinateOptions&
  operator=(const ConvertCoordinateOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConvertCoordinateOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastConvertCoordinateOptions : public ConvertCoordinateOptions
{
  inline FastConvertCoordinateOptions()
    : ConvertCoordinateOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TextOrElementOrDocument
{
  friend class TextOrElementOrDocumentArgument;
  enum Type
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Text> > mText;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;

  };

  Type mType;
  Value mValue;

  TextOrElementOrDocument(const TextOrElementOrDocument&) = delete;
  TextOrElementOrDocument& operator=(const TextOrElementOrDocument&) = delete;
public:
  explicit inline TextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~TextOrElementOrDocument()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Text>&
  RawSetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline NonNull<mozilla::dom::Text>&
  SetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    Uninit();
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline NonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline mozilla::dom::Text&
  GetAsText() const
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eText: {
        DestroyText();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    mValue.mText.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningTextOrElementOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);
  enum Type
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Text> > mText;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningTextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningTextOrElementOrDocument(const OwningTextOrElementOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTextOrElementOrDocument()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Text>&
  RawSetAsText();

  OwningNonNull<mozilla::dom::Text>&
  SetAsText();

  bool
  TrySetToText(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToText(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline OwningNonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline OwningNonNull<mozilla::dom::Text> const &
  GetAsText() const
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningTextOrElementOrDocument&
  operator=(const OwningTextOrElementOrDocument& aOther);

private:
  void
  DestroyText();

  void
  DestroyElement();

  void
  DestroyDocument();
};


struct BoxQuadOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR CSSBoxType mBox;
  MOZ_INIT_OUTSIDE_CTOR bool mCreateFramesForSuppressedWhitespace;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningTextOrElementOrDocument> mRelativeTo;

  BoxQuadOptions();

  explicit inline BoxQuadOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BoxQuadOptions(const BoxQuadOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mRelativeTo, "mRelativeTo", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mRelativeTo);
  }

  BoxQuadOptions&
  operator=(const BoxQuadOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BoxQuadOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBoxQuadOptions : public BoxQuadOptions
{
  inline FastBoxQuadOptions()
    : BoxQuadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_GeometryUtilsBinding_h
