/* THIS FILE IS AUTOGENERATED FROM ChromeUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ChromeUtilsBinding_h
#define mozilla_dom_ChromeUtilsBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct Base64URLDecodeOptionsAtoms;
struct Base64URLEncodeOptionsAtoms;
struct CategoryDispatchDictionary;
struct CategoryDispatchDictionaryAtoms;
struct ChildProcInfoDictionary;
struct ChildProcInfoDictionaryAtoms;
class ChromeUtils;
struct ChromeUtilsAtoms;
struct CompileScriptOptionsDictionaryAtoms;
struct HeapSnapshotBoundariesAtoms;
struct IOActivityDataDictionaryAtoms;
struct MediaMemoryInfoDictionary;
struct MediaMemoryInfoDictionaryAtoms;
struct MemoryInfoDictionary;
struct MemoryInfoDictionaryAtoms;
class MozQueryInterface;
struct MozQueryInterfaceAtoms;
struct NativePropertyHooks;
struct OriginAttributesDictionaryAtoms;
struct OriginAttributesPatternDictionaryAtoms;
struct ParentProcInfoDictionaryAtoms;
struct PerformanceInfoDictionaryAtoms;
class ProtoAndIfaceCache;
struct ThreadInfoDictionary;
struct ThreadInfoDictionaryAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class WebIDLProcType : uint8_t {
  Web,
  WebIsolated,
  File,
  Extension,
  Privilegedabout,
  Privilegedmozilla,
  WebLargeAllocation,
  WithCoopCoep,
  Browser,
  Plugin,
  IpdlUnitTest,
  GmpPlugin,
  Gpu,
  Vr,
  Rdd,
  Socket,
  RemoteSandboxBroker,
  Unknown,
  EndGuard_
};

namespace WebIDLProcTypeValues {
extern const EnumEntry strings[19];

static constexpr size_t Count = 18;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(WebIDLProcType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(WebIDLProcType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace WebIDLProcTypeValues

bool
ToJSValue(JSContext* aCx, WebIDLProcType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class Base64URLDecodePadding : uint8_t {
  Require,
  Ignore,
  Reject,
  EndGuard_
};

namespace Base64URLDecodePaddingValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(Base64URLDecodePadding::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(Base64URLDecodePadding stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace Base64URLDecodePaddingValues

bool
ToJSValue(JSContext* aCx, Base64URLDecodePadding aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PopupBlockerState : uint8_t {
  OpenAllowed,
  OpenControlled,
  OpenBlocked,
  OpenAbused,
  OpenOverridden,
  EndGuard_
};

namespace PopupBlockerStateValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PopupBlockerState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(PopupBlockerState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace PopupBlockerStateValues

bool
ToJSValue(JSContext* aCx, PopupBlockerState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MediaControlKeysTestEvent : uint8_t {
  Focus,
  Play,
  Pause,
  PlayPause,
  Previoustrack,
  Nexttrack,
  Seekbackward,
  Seekforward,
  Stop,
  EndGuard_
};

namespace MediaControlKeysTestEventValues {
extern const EnumEntry strings[10];

static constexpr size_t Count = 9;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaControlKeysTestEvent::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(MediaControlKeysTestEvent stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace MediaControlKeysTestEventValues

bool
ToJSValue(JSContext* aCx, MediaControlKeysTestEvent aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MediaSessionPlaybackTestState : uint8_t {
  Stopped,
  Paused,
  Playing,
  EndGuard_
};

namespace MediaSessionPlaybackTestStateValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaSessionPlaybackTestState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(MediaSessionPlaybackTestState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace MediaSessionPlaybackTestStateValues

bool
ToJSValue(JSContext* aCx, MediaSessionPlaybackTestState aArgument, JS::MutableHandle<JS::Value> aValue);


struct Base64URLDecodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Base64URLDecodePadding mPadding;

  Base64URLDecodeOptions();

  explicit inline Base64URLDecodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline Base64URLDecodeOptions(const Base64URLDecodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLDecodeOptions&
  operator=(const Base64URLDecodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, Base64URLDecodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLDecodeOptions : public Base64URLDecodeOptions
{
  inline FastBase64URLDecodeOptions()
    : Base64URLDecodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct Base64URLEncodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPad;

  Base64URLEncodeOptions();

  explicit inline Base64URLEncodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline Base64URLEncodeOptions(const Base64URLEncodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLEncodeOptions&
  operator=(const Base64URLEncodeOptions& aOther);

  bool
  operator==(const Base64URLEncodeOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, Base64URLEncodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLEncodeOptions : public Base64URLEncodeOptions
{
  inline FastBase64URLEncodeOptions()
    : Base64URLEncodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CategoryDispatchDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint16_t mCategory;
  MOZ_INIT_OUTSIDE_CTOR uint16_t mCount;

  CategoryDispatchDictionary();

  explicit inline CategoryDispatchDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CategoryDispatchDictionary(const CategoryDispatchDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CategoryDispatchDictionary&
  operator=(const CategoryDispatchDictionary& aOther);

  bool
  operator==(const CategoryDispatchDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CategoryDispatchDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastCategoryDispatchDictionary : public CategoryDispatchDictionary
{
  inline FastCategoryDispatchDictionary()
    : CategoryDispatchDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CompileScriptOptionsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCharset;
  MOZ_INIT_OUTSIDE_CTOR bool mHasReturnValue;
  MOZ_INIT_OUTSIDE_CTOR bool mLazilyParse;

  CompileScriptOptionsDictionary();

  explicit inline CompileScriptOptionsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CompileScriptOptionsDictionary(const CompileScriptOptionsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CompileScriptOptionsDictionary&
  operator=(const CompileScriptOptionsDictionary& aOther);

  bool
  operator==(const CompileScriptOptionsDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CompileScriptOptionsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastCompileScriptOptionsDictionary : public CompileScriptOptionsDictionary
{
  inline FastCompileScriptOptionsDictionary()
    : CompileScriptOptionsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HeapSnapshotBoundaries : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mDebugger;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JSObject*>> mGlobals;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mRuntime;

  HeapSnapshotBoundaries();

  explicit inline HeapSnapshotBoundaries(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  HeapSnapshotBoundaries(const HeapSnapshotBoundaries&) = delete;
  HeapSnapshotBoundaries& operator=(const HeapSnapshotBoundaries&) = delete;

  static bool
  InitIds(JSContext* cx, HeapSnapshotBoundariesAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHeapSnapshotBoundaries : public HeapSnapshotBoundaries
{
  inline FastHeapSnapshotBoundaries()
    : HeapSnapshotBoundaries(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IOActivityDataDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mLocation;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mRx;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mTx;

  IOActivityDataDictionary();

  explicit inline IOActivityDataDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline IOActivityDataDictionary(const IOActivityDataDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  IOActivityDataDictionary&
  operator=(const IOActivityDataDictionary& aOther);

  bool
  operator==(const IOActivityDataDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, IOActivityDataDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastIOActivityDataDictionary : public IOActivityDataDictionary
{
  inline FastIOActivityDataDictionary()
    : IOActivityDataDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaMemoryInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mAudioSize;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mResourcesSize;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mVideoSize;

  MediaMemoryInfoDictionary();

  explicit inline MediaMemoryInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaMemoryInfoDictionary(const MediaMemoryInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaMemoryInfoDictionary&
  operator=(const MediaMemoryInfoDictionary& aOther);

  bool
  operator==(const MediaMemoryInfoDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaMemoryInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaMemoryInfoDictionary : public MediaMemoryInfoDictionary
{
  inline FastMediaMemoryInfoDictionary()
    : MediaMemoryInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OriginAttributesDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mFirstPartyDomain;
  MOZ_INIT_OUTSIDE_CTOR nsString mGeckoViewSessionContextId;
  MOZ_INIT_OUTSIDE_CTOR bool mInIsolatedMozBrowser;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPrivateBrowsingId;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUserContextId;

  OriginAttributesDictionary();

  explicit inline OriginAttributesDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline OriginAttributesDictionary(const OriginAttributesDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  OriginAttributesDictionary&
  operator=(const OriginAttributesDictionary& aOther);

  bool
  operator==(const OriginAttributesDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, OriginAttributesDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastOriginAttributesDictionary : public OriginAttributesDictionary
{
  inline FastOriginAttributesDictionary()
    : OriginAttributesDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OriginAttributesPatternDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mFirstPartyDomain;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mGeckoViewSessionContextId;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mInIsolatedMozBrowser;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPrivateBrowsingId;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mUserContextId;

  OriginAttributesPatternDictionary();

  explicit inline OriginAttributesPatternDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline OriginAttributesPatternDictionary(const OriginAttributesPatternDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  OriginAttributesPatternDictionary&
  operator=(const OriginAttributesPatternDictionary& aOther);

  bool
  operator==(const OriginAttributesPatternDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, OriginAttributesPatternDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastOriginAttributesPatternDictionary : public OriginAttributesPatternDictionary
{
  inline FastOriginAttributesPatternDictionary()
    : OriginAttributesPatternDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ThreadInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuKernel;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuUser;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR int64_t mTid;

  ThreadInfoDictionary();

  explicit inline ThreadInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ThreadInfoDictionary(const ThreadInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ThreadInfoDictionary&
  operator=(const ThreadInfoDictionary& aOther);

  bool
  operator==(const ThreadInfoDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ThreadInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastThreadInfoDictionary : public ThreadInfoDictionary
{
  inline FastThreadInfoDictionary()
    : ThreadInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ChildProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mChildID;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuKernel;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuUser;
  MOZ_INIT_OUTSIDE_CTOR nsString mFilename;
  MOZ_INIT_OUTSIDE_CTOR nsString mOrigin;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR int64_t mResidentSetSize;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mVirtualMemorySize;

  ChildProcInfoDictionary();

  explicit inline ChildProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ChildProcInfoDictionary(const ChildProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ChildProcInfoDictionary&
  operator=(const ChildProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChildProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastChildProcInfoDictionary : public ChildProcInfoDictionary
{
  inline FastChildProcInfoDictionary()
    : ChildProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MemoryInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mGCHeapUsage;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomDom;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomOther;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomStyle;
  MOZ_INIT_OUTSIDE_CTOR MediaMemoryInfoDictionary mMedia;

  MemoryInfoDictionary();

  explicit inline MemoryInfoDictionary(const FastDictionaryInitializer& )
    : mMedia(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MemoryInfoDictionary(const MemoryInfoDictionary& aOther)
    : mMedia(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MemoryInfoDictionary&
  operator=(const MemoryInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, MemoryInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastMemoryInfoDictionary : public MemoryInfoDictionary
{
  inline FastMemoryInfoDictionary()
    : MemoryInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ParentProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<ChildProcInfoDictionary> mChildren;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuKernel;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuUser;
  MOZ_INIT_OUTSIDE_CTOR nsString mFilename;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR int64_t mResidentSetSize;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mVirtualMemorySize;

  ParentProcInfoDictionary();

  explicit inline ParentProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ParentProcInfoDictionary(const ParentProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ParentProcInfoDictionary&
  operator=(const ParentProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ParentProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastParentProcInfoDictionary : public ParentProcInfoDictionary
{
  inline FastParentProcInfoDictionary()
    : ParentProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PerformanceInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCounterId;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDuration;
  MOZ_INIT_OUTSIDE_CTOR nsCString mHost;
  MOZ_INIT_OUTSIDE_CTOR bool mIsTopLevel;
  MOZ_INIT_OUTSIDE_CTOR bool mIsWorker;
  MOZ_INIT_OUTSIDE_CTOR Sequence<CategoryDispatchDictionary> mItems;
  MOZ_INIT_OUTSIDE_CTOR MemoryInfoDictionary mMemoryInfo;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPid;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mWindowId;

  PerformanceInfoDictionary();

  explicit inline PerformanceInfoDictionary(const FastDictionaryInitializer& )
    : mMemoryInfo(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PerformanceInfoDictionary(const PerformanceInfoDictionary& aOther)
    : mMemoryInfo(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PerformanceInfoDictionary&
  operator=(const PerformanceInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, PerformanceInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastPerformanceInfoDictionary : public PerformanceInfoDictionary
{
  inline FastPerformanceInfoDictionary()
    : PerformanceInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ChromeUtils_Binding {

  typedef mozilla::dom::ChromeUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ChromeUtils,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace ChromeUtils_Binding



namespace MozQueryInterface_Binding {

  typedef mozilla::dom::MozQueryInterface NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozQueryInterface* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MozQueryInterface_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ChromeUtilsBinding_h
