/* THIS FILE IS AUTOGENERATED FROM CSSStyleSheet.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_CSSStyleSheetBinding_h
#define mozilla_dom_CSSStyleSheetBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

class StyleSheet;
struct StyleSheetAtoms;

namespace dom {

struct CSSStyleSheetInitAtoms;
class MediaList;
class MediaListOrString;
struct NativePropertyHooks;
class OwningMediaListOrString;
class ProtoAndIfaceCache;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CSSStyleSheetParsingMode : uint8_t {
  Author,
  User,
  Agent,
  EndGuard_
};

namespace CSSStyleSheetParsingModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CSSStyleSheetParsingMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(CSSStyleSheetParsingMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace CSSStyleSheetParsingModeValues

bool
ToJSValue(JSContext* aCx, CSSStyleSheetParsingMode aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMediaListOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMediaListOrString& aUnion);


class MediaListOrString
{
  friend class MediaListOrStringArgument;
  enum Type
  {
    eUninitialized,
    eMediaList,
    eString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  MediaListOrString(const MediaListOrString&) = delete;
  MediaListOrString& operator=(const MediaListOrString&) = delete;
public:
  explicit inline MediaListOrString()
    : mType(eUninitialized)
  {
  }

  inline ~MediaListOrString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  inline NonNull<mozilla::dom::MediaList>&
  SetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    Uninit();
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline NonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline mozilla::dom::MediaList&
  GetAsMediaList() const
  {
    MOZ_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMediaList: {
        DestroyMediaList();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyMediaList()
  {
    MOZ_ASSERT(IsMediaList(), "Wrong type!");
    mValue.mMediaList.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningMediaListOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMediaListOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eMediaList,
    eString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningMediaListOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningMediaListOrString(const OwningMediaListOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMediaListOrString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList();

  OwningNonNull<mozilla::dom::MediaList>&
  SetAsMediaList();

  bool
  TrySetToMediaList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline OwningNonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline OwningNonNull<mozilla::dom::MediaList> const &
  GetAsMediaList() const
  {
    MOZ_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMediaListOrString&
  operator=(const OwningMediaListOrString& aOther);

private:
  void
  DestroyMediaList();

  void
  DestroyString();
};


struct CSSStyleSheetInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mBaseURL;
  MOZ_INIT_OUTSIDE_CTOR bool mDisabled;
  MOZ_INIT_OUTSIDE_CTOR OwningMediaListOrString mMedia;

  CSSStyleSheetInit();

  explicit inline CSSStyleSheetInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CSSStyleSheetInit(const CSSStyleSheetInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mMedia, "mMedia", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mMedia);
  }

  CSSStyleSheetInit&
  operator=(const CSSStyleSheetInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, CSSStyleSheetInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastCSSStyleSheetInit : public CSSStyleSheetInit
{
  inline FastCSSStyleSheetInit()
    : CSSStyleSheetInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace CSSStyleSheet_Binding {

  typedef mozilla::StyleSheet NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::StyleSheet* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CSSStyleSheet,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSStyleSheet,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace CSSStyleSheet_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_CSSStyleSheetBinding_h
