/* THIS FILE IS AUTOGENERATED FROM BaseKeyframeTypes.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_BaseKeyframeTypesBinding_h
#define mozilla_dom_BaseKeyframeTypesBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

struct BaseComputedKeyframeAtoms;
struct BaseKeyframeAtoms;
struct BasePropertyIndexedKeyframeAtoms;
class CompositeOperationOrAutoOrCompositeOperationOrAutoSequence;
class DoubleOrNullOrDoubleOrNullSequence;
struct NativePropertyHooks;
class OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence;
class OwningDoubleOrNullOrDoubleOrNullSequence;
class OwningStringOrStringSequence;
class ProtoAndIfaceCache;
class StringOrStringSequence;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CompositeOperation : uint8_t {
  Replace,
  Add,
  Accumulate,
  EndGuard_
};

namespace CompositeOperationValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CompositeOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(CompositeOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace CompositeOperationValues

bool
ToJSValue(JSContext* aCx, CompositeOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class CompositeOperationOrAuto : uint8_t {
  Replace,
  Add,
  Accumulate,
  Auto,
  EndGuard_
};

namespace CompositeOperationOrAutoValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CompositeOperationOrAuto::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(CompositeOperationOrAuto stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace CompositeOperationOrAutoValues

bool
ToJSValue(JSContext* aCx, CompositeOperationOrAuto aArgument, JS::MutableHandle<JS::Value> aValue);


struct BaseKeyframe : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR CompositeOperationOrAuto mComposite;
  MOZ_INIT_OUTSIDE_CTOR nsString mEasing;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mOffset;
  MOZ_INIT_OUTSIDE_CTOR bool mSimulateComputeValuesFailure;

  BaseKeyframe();

  explicit inline BaseKeyframe(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BaseKeyframe(const BaseKeyframe& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  BaseKeyframe&
  operator=(const BaseKeyframe& aOther);

private:
  static bool
  InitIds(JSContext* cx, BaseKeyframeAtoms* atomsCache);
};

namespace binding_detail {
struct FastBaseKeyframe : public BaseKeyframe
{
  inline FastBaseKeyframe()
    : BaseKeyframe(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class CompositeOperationOrAutoOrCompositeOperationOrAutoSequence
{
  friend class CompositeOperationOrAutoOrCompositeOperationOrAutoSequenceArgument;
  enum Type
  {
    eUninitialized,
    eCompositeOperationOrAuto,
    eCompositeOperationOrAutoSequence
  };

  union Value
  {
    UnionMember<CompositeOperationOrAuto > mCompositeOperationOrAuto;
    UnionMember<binding_detail::AutoSequence<CompositeOperationOrAuto> > mCompositeOperationOrAutoSequence;

  };

  Type mType;
  Value mValue;

  CompositeOperationOrAutoOrCompositeOperationOrAutoSequence(const CompositeOperationOrAutoOrCompositeOperationOrAutoSequence&) = delete;
  CompositeOperationOrAutoOrCompositeOperationOrAutoSequence& operator=(const CompositeOperationOrAutoOrCompositeOperationOrAutoSequence&) = delete;
public:
  explicit inline CompositeOperationOrAutoOrCompositeOperationOrAutoSequence()
    : mType(eUninitialized)
  {
  }

  inline ~CompositeOperationOrAutoOrCompositeOperationOrAutoSequence()
  {
    Uninit();
  }

  inline CompositeOperationOrAuto&
  RawSetAsCompositeOperationOrAuto()
  {
    if (mType == eCompositeOperationOrAuto) {
      return mValue.mCompositeOperationOrAuto.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCompositeOperationOrAuto;
    return mValue.mCompositeOperationOrAuto.SetValue();
  }

  inline CompositeOperationOrAuto&
  SetAsCompositeOperationOrAuto()
  {
    if (mType == eCompositeOperationOrAuto) {
      return mValue.mCompositeOperationOrAuto.Value();
    }
    Uninit();
    mType = eCompositeOperationOrAuto;
    return mValue.mCompositeOperationOrAuto.SetValue();
  }

  inline bool
  IsCompositeOperationOrAuto() const
  {
    return mType == eCompositeOperationOrAuto;
  }

  inline CompositeOperationOrAuto&
  GetAsCompositeOperationOrAuto()
  {
    MOZ_ASSERT(IsCompositeOperationOrAuto(), "Wrong type!");
    return mValue.mCompositeOperationOrAuto.Value();
  }

  inline CompositeOperationOrAuto
  GetAsCompositeOperationOrAuto() const
  {
    MOZ_ASSERT(IsCompositeOperationOrAuto(), "Wrong type!");
    return mValue.mCompositeOperationOrAuto.Value();
  }

  inline binding_detail::AutoSequence<CompositeOperationOrAuto>&
  RawSetAsCompositeOperationOrAutoSequence()
  {
    if (mType == eCompositeOperationOrAutoSequence) {
      return mValue.mCompositeOperationOrAutoSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCompositeOperationOrAutoSequence;
    return mValue.mCompositeOperationOrAutoSequence.SetValue();
  }

  inline binding_detail::AutoSequence<CompositeOperationOrAuto>&
  SetAsCompositeOperationOrAutoSequence()
  {
    if (mType == eCompositeOperationOrAutoSequence) {
      return mValue.mCompositeOperationOrAutoSequence.Value();
    }
    Uninit();
    mType = eCompositeOperationOrAutoSequence;
    return mValue.mCompositeOperationOrAutoSequence.SetValue();
  }

  inline bool
  IsCompositeOperationOrAutoSequence() const
  {
    return mType == eCompositeOperationOrAutoSequence;
  }

  inline binding_detail::AutoSequence<CompositeOperationOrAuto>&
  GetAsCompositeOperationOrAutoSequence()
  {
    MOZ_ASSERT(IsCompositeOperationOrAutoSequence(), "Wrong type!");
    return mValue.mCompositeOperationOrAutoSequence.Value();
  }

  inline const Sequence<CompositeOperationOrAuto>&
  GetAsCompositeOperationOrAutoSequence() const
  {
    MOZ_ASSERT(IsCompositeOperationOrAutoSequence(), "Wrong type!");
    return mValue.mCompositeOperationOrAutoSequence.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCompositeOperationOrAuto: {
        DestroyCompositeOperationOrAuto();
        break;
      }
      case eCompositeOperationOrAutoSequence: {
        DestroyCompositeOperationOrAutoSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyCompositeOperationOrAuto()
  {
    MOZ_ASSERT(IsCompositeOperationOrAuto(), "Wrong type!");
    mValue.mCompositeOperationOrAuto.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyCompositeOperationOrAutoSequence()
  {
    MOZ_ASSERT(IsCompositeOperationOrAutoSequence(), "Wrong type!");
    mValue.mCompositeOperationOrAutoSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence& aUnion);
  enum Type
  {
    eUninitialized,
    eCompositeOperationOrAuto,
    eCompositeOperationOrAutoSequence
  };

  union Value
  {
    UnionMember<CompositeOperationOrAuto > mCompositeOperationOrAuto;
    UnionMember<Sequence<CompositeOperationOrAuto> > mCompositeOperationOrAutoSequence;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence(const OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence()
  {
    Uninit();
  }

  CompositeOperationOrAuto&
  RawSetAsCompositeOperationOrAuto();

  CompositeOperationOrAuto&
  SetAsCompositeOperationOrAuto();

  bool
  TrySetToCompositeOperationOrAuto(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCompositeOperationOrAuto(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsCompositeOperationOrAuto() const
  {
    return mType == eCompositeOperationOrAuto;
  }

  inline CompositeOperationOrAuto&
  GetAsCompositeOperationOrAuto()
  {
    MOZ_ASSERT(IsCompositeOperationOrAuto(), "Wrong type!");
    return mValue.mCompositeOperationOrAuto.Value();
  }

  inline CompositeOperationOrAuto const &
  GetAsCompositeOperationOrAuto() const
  {
    MOZ_ASSERT(IsCompositeOperationOrAuto(), "Wrong type!");
    return mValue.mCompositeOperationOrAuto.Value();
  }

  Sequence<CompositeOperationOrAuto>&
  RawSetAsCompositeOperationOrAutoSequence();

  Sequence<CompositeOperationOrAuto>&
  SetAsCompositeOperationOrAutoSequence();

  bool
  TrySetToCompositeOperationOrAutoSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCompositeOperationOrAutoSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsCompositeOperationOrAutoSequence() const
  {
    return mType == eCompositeOperationOrAutoSequence;
  }

  inline Sequence<CompositeOperationOrAuto>&
  GetAsCompositeOperationOrAutoSequence()
  {
    MOZ_ASSERT(IsCompositeOperationOrAutoSequence(), "Wrong type!");
    return mValue.mCompositeOperationOrAutoSequence.Value();
  }

  inline Sequence<CompositeOperationOrAuto> const &
  GetAsCompositeOperationOrAutoSequence() const
  {
    MOZ_ASSERT(IsCompositeOperationOrAutoSequence(), "Wrong type!");
    return mValue.mCompositeOperationOrAutoSequence.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence&
  operator=(const OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence& aOther);

private:
  void
  DestroyCompositeOperationOrAuto();

  void
  DestroyCompositeOperationOrAutoSequence();
};


class DoubleOrNullOrDoubleOrNullSequence
{
  friend class DoubleOrNullOrDoubleOrNullSequenceArgument;
  enum Type
  {
    eUninitialized,
    eNull,
    eDouble,
    eDoubleOrNullSequence
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::AutoSequence<Nullable<double>> > mDoubleOrNullSequence;

  };

  Type mType;
  Value mValue;

  DoubleOrNullOrDoubleOrNullSequence(const DoubleOrNullOrDoubleOrNullSequence&) = delete;
  DoubleOrNullOrDoubleOrNullSequence& operator=(const DoubleOrNullOrDoubleOrNullSequence&) = delete;
public:
  explicit inline DoubleOrNullOrDoubleOrNullSequence()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrNullOrDoubleOrNullSequence()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline binding_detail::AutoSequence<Nullable<double>>&
  RawSetAsDoubleOrNullSequence()
  {
    if (mType == eDoubleOrNullSequence) {
      return mValue.mDoubleOrNullSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleOrNullSequence;
    return mValue.mDoubleOrNullSequence.SetValue();
  }

  inline binding_detail::AutoSequence<Nullable<double>>&
  SetAsDoubleOrNullSequence()
  {
    if (mType == eDoubleOrNullSequence) {
      return mValue.mDoubleOrNullSequence.Value();
    }
    Uninit();
    mType = eDoubleOrNullSequence;
    return mValue.mDoubleOrNullSequence.SetValue();
  }

  inline bool
  IsDoubleOrNullSequence() const
  {
    return mType == eDoubleOrNullSequence;
  }

  inline binding_detail::AutoSequence<Nullable<double>>&
  GetAsDoubleOrNullSequence()
  {
    MOZ_ASSERT(IsDoubleOrNullSequence(), "Wrong type!");
    return mValue.mDoubleOrNullSequence.Value();
  }

  inline const Sequence<Nullable<double>>&
  GetAsDoubleOrNullSequence() const
  {
    MOZ_ASSERT(IsDoubleOrNullSequence(), "Wrong type!");
    return mValue.mDoubleOrNullSequence.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eNull: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eDoubleOrNullSequence: {
        DestroyDoubleOrNullSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDoubleOrNullSequence()
  {
    MOZ_ASSERT(IsDoubleOrNullSequence(), "Wrong type!");
    mValue.mDoubleOrNullSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleOrNullOrDoubleOrNullSequence : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDoubleOrNullOrDoubleOrNullSequence& aUnion);
  enum Type
  {
    eUninitialized,
    eNull,
    eDouble,
    eDoubleOrNullSequence
  };

  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<Sequence<Nullable<double>> > mDoubleOrNullSequence;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrNullOrDoubleOrNullSequence()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningDoubleOrNullOrDoubleOrNullSequence(const OwningDoubleOrNullOrDoubleOrNullSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrNullOrDoubleOrNullSequence()
  {
    Uninit();
  }

  inline bool
  IsNull() const
  {
    return mType == eNull;
  }

  inline void
  SetNull()
  {
    Uninit();
    mType = eNull;
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  Sequence<Nullable<double>>&
  RawSetAsDoubleOrNullSequence();

  Sequence<Nullable<double>>&
  SetAsDoubleOrNullSequence();

  bool
  TrySetToDoubleOrNullSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleOrNullSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDoubleOrNullSequence() const
  {
    return mType == eDoubleOrNullSequence;
  }

  inline Sequence<Nullable<double>>&
  GetAsDoubleOrNullSequence()
  {
    MOZ_ASSERT(IsDoubleOrNullSequence(), "Wrong type!");
    return mValue.mDoubleOrNullSequence.Value();
  }

  inline Sequence<Nullable<double>> const &
  GetAsDoubleOrNullSequence() const
  {
    MOZ_ASSERT(IsDoubleOrNullSequence(), "Wrong type!");
    return mValue.mDoubleOrNullSequence.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningDoubleOrNullOrDoubleOrNullSequence&
  operator=(const OwningDoubleOrNullOrDoubleOrNullSequence& aOther);

private:
  void
  DestroyDouble();

  void
  DestroyDoubleOrNullSequence();
};


struct BaseComputedKeyframe : public BaseKeyframe
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mComputedOffset;

  BaseComputedKeyframe();

  explicit inline BaseComputedKeyframe(const FastDictionaryInitializer& )
    : BaseKeyframe(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BaseComputedKeyframe(const BaseComputedKeyframe& aOther)
    : BaseKeyframe(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  BaseComputedKeyframe&
  operator=(const BaseComputedKeyframe& aOther);

  bool
  operator==(const BaseComputedKeyframe& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, BaseComputedKeyframeAtoms* atomsCache);
};

namespace binding_detail {
struct FastBaseComputedKeyframe : public BaseComputedKeyframe
{
  inline FastBaseComputedKeyframe()
    : BaseComputedKeyframe(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct BasePropertyIndexedKeyframe : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningCompositeOperationOrAutoOrCompositeOperationOrAutoSequence mComposite;
  MOZ_INIT_OUTSIDE_CTOR OwningStringOrStringSequence mEasing;
  MOZ_INIT_OUTSIDE_CTOR OwningDoubleOrNullOrDoubleOrNullSequence mOffset;

  BasePropertyIndexedKeyframe();

  explicit inline BasePropertyIndexedKeyframe(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BasePropertyIndexedKeyframe(const BasePropertyIndexedKeyframe& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BasePropertyIndexedKeyframe&
  operator=(const BasePropertyIndexedKeyframe& aOther);

private:
  static bool
  InitIds(JSContext* cx, BasePropertyIndexedKeyframeAtoms* atomsCache);
};

namespace binding_detail {
struct FastBasePropertyIndexedKeyframe : public BasePropertyIndexedKeyframe
{
  inline FastBasePropertyIndexedKeyframe()
    : BasePropertyIndexedKeyframe(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_BaseKeyframeTypesBinding_h
