/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous191,
  Anonymous314,
  Anonymous193,
  Anonymous410,
  Anonymous079,
  Anonymous260,
  Anonymous380,
  Anonymous183,
  Anonymous086,
  Anonymous168,
  Anonymous090,
  Anonymous015,
  Anonymous049,
  Anonymous142,
  Anonymous202,
  OfflineCacheUpdate,
  Anonymous296,
  Anonymous295,
  Anonymous327,
  Anonymous123,
  Anonymous316,
  Anonymous027,
  Anonymous040,
  Anonymous264,
  Anonymous345,
  Anonymous262,
  Anonymous412,
  Anonymous278,
  Anonymous153,
  Anonymous170,
  Anonymous368,
  Anonymous125,
  Anonymous414,
  Anonymous211,
  Anonymous083,
  Anonymous330,
  Anonymous236,
  Anonymous189,
  Anonymous321,
  Anonymous244,
  Anonymous299,
  Anonymous287,
  Anonymous377,
  Anonymous081,
  Anonymous018,
  Anonymous025,
  Anonymous012,
  Anonymous110,
  Anonymous177,
  Anonymous033,
  RemoteWebProgress,
  Anonymous243,
  Anonymous381,
  Anonymous353,
  Anonymous252,
  Anonymous325,
  Anonymous066,
  Anonymous198,
  Anonymous077,
  Anonymous253,
  Anonymous034,
  Anonymous148,
  Anonymous163,
  Anonymous073,
  Anonymous116,
  Anonymous117,
  Anonymous293,
  Anonymous370,
  Anonymous363,
  Anonymous085,
  Anonymous113,
  Anonymous281,
  Anonymous201,
  Anonymous224,
  Anonymous307,
  Anonymous054,
  Anonymous045,
  Anonymous100,
  Anonymous320,
  Anonymous078,
  NativeFileWatcher,
  Anonymous185,
  Anonymous169,
  Anonymous384,
  Anonymous203,
  Anonymous151,
  Anonymous215,
  Anonymous235,
  Anonymous173,
  Anonymous254,
  Anonymous337,
  Anonymous149,
  Anonymous041,
  Anonymous317,
  Anonymous143,
  Anonymous383,
  Anonymous133,
  Anonymous196,
  Anonymous082,
  Anonymous324,
  Anonymous272,
  Anonymous158,
  Anonymous416,
  Anonymous249,
  Anonymous401,
  Anonymous285,
  Anonymous309,
  Anonymous059,
  Anonymous322,
  Anonymous179,
  Anonymous071,
  Anonymous008,
  Anonymous358,
  Anonymous007,
  Anonymous132,
  Anonymous042,
  Anonymous144,
  Anonymous391,
  Anonymous156,
  Anonymous108,
  Anonymous031,
  Anonymous046,
  Anonymous028,
  Anonymous050,
  Anonymous190,
  Anonymous217,
  Anonymous419,
  Anonymous226,
  Anonymous106,
  Anonymous088,
  Anonymous160,
  Anonymous396,
  Anonymous005,
  Anonymous248,
  Anonymous230,
  Anonymous356,
  Anonymous162,
  AppStartup,
  Anonymous258,
  Anonymous239,
  Anonymous276,
  Anonymous164,
  Anonymous000,
  Anonymous261,
  Anonymous263,
  Anonymous178,
  RemoteWebProgressRequest,
  Anonymous072,
  Anonymous351,
  Anonymous265,
  Anonymous402,
  Anonymous187,
  Anonymous344,
  Anonymous268,
  Anonymous095,
  Anonymous411,
  Anonymous056,
  Anonymous392,
  Anonymous291,
  Anonymous271,
  Anonymous060,
  Anonymous400,
  Anonymous311,
  Anonymous107,
  Anonymous259,
  Anonymous269,
  Anonymous289,
  Anonymous112,
  Anonymous131,
  Anonymous111,
  DocLoader,
  Anonymous051,
  Anonymous372,
  Anonymous014,
  Anonymous256,
  Anonymous341,
  Anonymous020,
  Anonymous016,
  Anonymous294,
  Anonymous167,
  TypeAheadFind,
  Anonymous284,
  Anonymous375,
  Anonymous397,
  Anonymous279,
  Anonymous174,
  Anonymous333,
  Anonymous002,
  Anonymous231,
  Anonymous076,
  Anonymous104,
  LoginReputation,
  Anonymous395,
  Anonymous026,
  Anonymous331,
  Anonymous115,
  Anonymous089,
  Anonymous062,
  Anonymous197,
  URILoader,
  Anonymous423,
  Anonymous366,
  Anonymous369,
  Anonymous266,
  Anonymous048,
  Anonymous413,
  Anonymous275,
  Anonymous099,
  Anonymous390,
  ApplicationReputation,
  Anonymous138,
  Anonymous352,
  Anonymous152,
  Anonymous250,
  Anonymous068,
  Anonymous406,
  Anonymous209,
  Anonymous216,
  Anonymous359,
  Anonymous312,
  Anonymous398,
  Anonymous214,
  Anonymous038,
  Anonymous313,
  Anonymous204,
  Anonymous021,
  Anonymous023,
  Anonymous273,
  Anonymous024,
  Anonymous037,
  Anonymous360,
  Anonymous270,
  Anonymous063,
  Anonymous091,
  Anonymous035,
  Anonymous119,
  Anonymous022,
  Anonymous194,
  Anonymous292,
  Anonymous237,
  Anonymous047,
  Anonymous361,
  Anonymous092,
  Anonymous141,
  Anonymous157,
  Anonymous308,
  Anonymous300,
  Anonymous013,
  Anonymous039,
  AlertNotification,
  Anonymous171,
  Anonymous404,
  Anonymous371,
  UrlClassifierDB,
  Anonymous304,
  Anonymous032,
  Anonymous155,
  Anonymous220,
  Anonymous102,
  Anonymous057,
  Anonymous228,
  Anonymous342,
  Anonymous315,
  Anonymous044,
  Anonymous241,
  Anonymous130,
  Anonymous219,
  FindService,
  Anonymous407,
  Anonymous227,
  Anonymous347,
  Anonymous303,
  Anonymous367,
  Anonymous010,
  Anonymous277,
  Anonymous184,
  Anonymous409,
  Anonymous175,
  Anonymous118,
  Anonymous418,
  Anonymous139,
  Anonymous165,
  Anonymous075,
  Anonymous225,
  Anonymous288,
  Anonymous306,
  Anonymous332,
  Anonymous120,
  Anonymous001,
  Anonymous343,
  Anonymous424,
  AsyncShutdown,
  Anonymous210,
  Anonymous096,
  Anonymous097,
  Anonymous267,
  Anonymous029,
  UrlClassifierStreamUpdater,
  Anonymous348,
  Anonymous218,
  Anonymous339,
  Anonymous172,
  Anonymous181,
  Anonymous166,
  Anonymous374,
  Anonymous052,
  Anonymous134,
  Anonymous093,
  Anonymous223,
  Anonymous195,
  Anonymous355,
  Anonymous425,
  Anonymous365,
  Anonymous074,
  Anonymous280,
  Anonymous212,
  Anonymous364,
  Anonymous326,
  Anonymous290,
  Anonymous176,
  Anonymous388,
  Anonymous017,
  Anonymous103,
  Anonymous382,
  Anonymous310,
  Anonymous030,
  Anonymous415,
  Anonymous140,
  Anonymous387,
  Anonymous019,
  Anonymous137,
  Anonymous246,
  Anonymous121,
  Anonymous385,
  Anonymous283,
  Anonymous301,
  Anonymous389,
  Anonymous362,
  Prefetch,
  Anonymous233,
  Anonymous208,
  Anonymous238,
  Anonymous145,
  Anonymous426,
  Anonymous257,
  DownloadPlatform,
  Anonymous094,
  Anonymous298,
  Anonymous207,
  Anonymous127,
  Alerts,
  Anonymous318,
  Anonymous242,
  Anonymous136,
  Anonymous114,
  Anonymous058,
  Anonymous354,
  Anonymous221,
  Anonymous154,
  Anonymous420,
  URIFixup,
  Anonymous159,
  Anonymous245,
  Anonymous146,
  Anonymous124,
  Anonymous070,
  Anonymous186,
  UrlClassifierUtils,
  Anonymous182,
  ExtensionPolicy,
  Anonymous417,
  Anonymous297,
  Anonymous229,
  Anonymous147,
  Anonymous043,
  Anonymous161,
  Anonymous200,
  Anonymous405,
  Anonymous101,
  Anonymous421,
  Anonymous251,
  Anonymous340,
  Anonymous274,
  Anonymous346,
  Anonymous065,
  Anonymous323,
  Anonymous098,
  Anonymous319,
  Anonymous336,
  Anonymous192,
  Anonymous232,
  Anonymous036,
  Anonymous126,
  Anonymous109,
  Anonymous328,
  Anonymous006,
  Anonymous376,
  Anonymous302,
  Anonymous282,
  Anonymous064,
  Anonymous004,
  AddonContentPolicy,
  Anonymous286,
  Anonymous009,
  Anonymous084,
  Anonymous305,
  Anonymous234,
  Anonymous222,
  Anonymous135,
  Anonymous206,
  Anonymous329,
  Anonymous105,
  Anonymous129,
  Anonymous393,
  Anonymous335,
  Anonymous422,
  Anonymous188,
  Anonymous087,
  Anonymous399,
  Anonymous240,
  Anonymous350,
  Anonymous386,
  Anonymous373,
  UrlClassifierPrefixSet,
  Anonymous067,
  Anonymous213,
  Anonymous403,
  Anonymous069,
  Anonymous011,
  Anonymous357,
  Anonymous338,
  Anonymous080,
  Anonymous334,
  Anonymous003,
  Anonymous053,
  Anonymous408,
  Anonymous150,
  Anonymous055,
  Anonymous247,
  Anonymous255,
  Anonymous379,
  Anonymous378,
  Anonymous394,
  Anonymous128,
  Anonymous349,
  Anonymous180,
  Anonymous199,
  Anonymous122,
  Anonymous061,
  Anonymous205,

};

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace LoginReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::LoginReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::LoginReputation, aRv};
}
}  // namespace LoginReputation

namespace NativeFileWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NativeFileWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NativeFileWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NativeFileWatcher, aRv};
}
}  // namespace NativeFileWatcher

namespace OfflineCacheUpdate {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::OfflineCacheUpdate);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::OfflineCacheUpdate, aRv};
}
}  // namespace OfflineCacheUpdate

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace RemoteWebProgress {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RemoteWebProgress);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RemoteWebProgress, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RemoteWebProgress, aRv};
}
}  // namespace RemoteWebProgress

namespace RemoteWebProgressRequest {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RemoteWebProgressRequest);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RemoteWebProgressRequest, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RemoteWebProgressRequest, aRv};
}
}  // namespace RemoteWebProgressRequest

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

}  // namespace components

}  // namespace mozilla

#endif
