/* This file was autogenerated by toolkit/crashreporter/generate_crash_reporter_sources.py. DO NOT EDIT */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef CrashAnnotations_h
#define CrashAnnotations_h

#include <cstddef>
#include <cstdint>

namespace CrashReporter {

// Typed enum representing all crash annotations
enum class Annotation : uint32_t {
  A11yHandlerRegistered = 0,
  AbortMessage = 1,
  Accessibility = 2,
  AccessibilityClient = 3,
  AccessibilityInProcClient = 4,
  ActualStreamLen = 5,
  AdapterDeviceID = 6,
  AdapterDriverVendor = 7,
  AdapterDriverVersion = 8,
  AdapterSubsysID = 9,
  AdapterVendorID = 10,
  Addons = 11,
  AppInitDLLs = 12,
  AsyncShutdownModule = 13,
  AsyncShutdownTimeout = 14,
  AvailablePageFile = 15,
  AvailablePhysicalMemory = 16,
  AvailableSwapMemory = 17,
  AvailableVirtualMemory = 18,
  BIOS_Manufacturer = 19,
  BlockedDllList = 20,
  BlocklistInitFailed = 21,
  Breadcrumbs = 22,
  BreakpadReserveAddress = 23,
  BreakpadReserveSize = 24,
  Bug_1086977 = 25,
  Bug_1541161 = 26,
  BuildID = 27,
  CPUMicrocodeVersion = 28,
  ClassRegistrationInfoChild = 29,
  ClassRegistrationInfoParent = 30,
  CoMarshalInterfaceFailure = 31,
  CoUnmarshalInterfaceResult = 32,
  ContainsMemoryReport = 33,
  ContentSandboxCapabilities = 34,
  ContentSandboxCapable = 35,
  ContentSandboxEnabled = 36,
  ContentSandboxLevel = 37,
  CpuUsageFlashProcess1 = 38,
  CpuUsageFlashProcess2 = 39,
  CrashAddressLikelyWrong = 40,
  CrashTime = 41,
  CreateStreamOnHGlobalFailure = 42,
  CycleCollector = 43,
  DOMFissionEnabled = 44,
  DOMIPCEnabled = 45,
  DesktopEnvironment = 46,
  DeviceResetReason = 47,
  EMCheckCompatibility = 48,
  EventLoopNestingLevel = 49,
  ExpectedStreamLen = 50,
  FlashProcessDump = 51,
  FramePoisonBase = 52,
  FramePoisonSize = 53,
  GMPLibraryPath = 54,
  GMPPlugin = 55,
  GPUProcessLaunchCount = 56,
  GPUProcessStatus = 57,
  GetHGlobalFromStreamFailure = 58,
  GraphicsCriticalError = 59,
  GraphicsSanityTest = 60,
  GraphicsStartupTest = 61,
  HangMonitorDescription = 62,
  HasDeviceTouchScreen = 63,
  IAccessibleConfig = 64,
  IPCFatalErrorMsg = 65,
  IPCFatalErrorProtocol = 66,
  IPCMessageName = 67,
  IPCMessageSize = 68,
  IPCReadErrorReason = 69,
  IPCShutdownState = 70,
  IPCSystemError = 71,
  IPCTransportFailureReason = 72,
  IndexedDBShutdownTimeout = 73,
  InstallTime = 74,
  InterfaceRegistrationInfoChild = 75,
  InterfaceRegistrationInfoParent = 76,
  IpcCreateEndpointsNsresult = 77,
  IpcCreatePipeCloExecErrno = 78,
  IpcCreatePipeFcntlErrno = 79,
  IpcCreatePipeSocketPairErrno = 80,
  IpcCreateTransportDupErrno = 81,
  IsGarbageCollecting = 82,
  IsWayland = 83,
  IsWaylandDRM = 84,
  JSActorMessage = 85,
  JSActorName = 86,
  JSLargeAllocationFailure = 87,
  JSOutOfMemory = 88,
  JavaStackTrace = 89,
  LauncherProcessState = 90,
  LocalStorageShutdownTimeout = 91,
  LowCommitSpaceEvents = 92,
  MainThreadRunnableName = 93,
  MarshalActCtxManifestPath = 94,
  MemoryErrorCorrection = 95,
  MozCrashReason = 96,
  Notes = 97,
  OOMAllocationSize = 98,
  PHCAllocStack = 99,
  PHCBaseAddress = 100,
  PHCFreeStack = 101,
  PHCKind = 102,
  PHCUsableSize = 103,
  PluginCpuUsage = 104,
  PluginFilename = 105,
  PluginHang = 106,
  PluginHangUIDuration = 107,
  PluginName = 108,
  PluginVersion = 109,
  ProcessType = 110,
  ProductID = 111,
  ProductName = 112,
  ProxyStreamSize = 113,
  ProxyStreamSizeFrom = 114,
  ProxyStreamUnmarshalStatus = 115,
  ProxyStreamValid = 116,
  PurgeablePhysicalMemory = 117,
  RDDProcessStatus = 118,
  ReleaseChannel = 119,
  RemoteType = 120,
  SafeMode = 121,
  SecondsSinceLastCrash = 122,
  ServerURL = 123,
  ShutdownProgress = 124,
  StartupCrash = 125,
  StartupTime = 126,
  StatFailure = 127,
  StorageConnectionNotClosed = 128,
  SubmittedFromInfobar = 129,
  SystemMemoryUsePercentage = 130,
  TelemetryClientId = 131,
  TelemetryEnvironment = 132,
  TelemetryServerURL = 133,
  TelemetrySessionId = 134,
  TestKey = 135,
  TestUnicode = 136,
  TextureUsage = 137,
  ThreadIdNameMapping = 138,
  TotalPageFile = 139,
  TotalPhysicalMemory = 140,
  TotalVirtualMemory = 141,
  URL = 142,
  UnknownNetAddrSocketFamily = 143,
  UnmarshalActCtx = 144,
  UnmarshalActCtxManifestPath = 145,
  UptimeTS = 146,
  User32BeforeBlocklist = 147,
  VRProcessStatus = 148,
  Vendor = 149,
  Version = 150,
  Winsock_LSP = 151,
  additional_minidumps = 152,
  ipc_channel_error = 153,
  nsAsyncShutdownComponent = 154,
  useragent_locale = 155,
  Count = 156
};

// Stringified crash annotation names
const char* const kAnnotationStrings[] = {
  "A11yHandlerRegistered",
  "AbortMessage",
  "Accessibility",
  "AccessibilityClient",
  "AccessibilityInProcClient",
  "ActualStreamLen",
  "AdapterDeviceID",
  "AdapterDriverVendor",
  "AdapterDriverVersion",
  "AdapterSubsysID",
  "AdapterVendorID",
  "Add-ons",
  "AppInitDLLs",
  "AsyncShutdownModule",
  "AsyncShutdownTimeout",
  "AvailablePageFile",
  "AvailablePhysicalMemory",
  "AvailableSwapMemory",
  "AvailableVirtualMemory",
  "BIOS_Manufacturer",
  "BlockedDllList",
  "BlocklistInitFailed",
  "Breadcrumbs",
  "BreakpadReserveAddress",
  "BreakpadReserveSize",
  "Bug_1086977",
  "Bug_1541161",
  "BuildID",
  "CPUMicrocodeVersion",
  "ClassRegistrationInfoChild",
  "ClassRegistrationInfoParent",
  "CoMarshalInterfaceFailure",
  "CoUnmarshalInterfaceResult",
  "ContainsMemoryReport",
  "ContentSandboxCapabilities",
  "ContentSandboxCapable",
  "ContentSandboxEnabled",
  "ContentSandboxLevel",
  "CpuUsageFlashProcess1",
  "CpuUsageFlashProcess2",
  "CrashAddressLikelyWrong",
  "CrashTime",
  "CreateStreamOnHGlobalFailure",
  "CycleCollector",
  "DOMFissionEnabled",
  "DOMIPCEnabled",
  "DesktopEnvironment",
  "DeviceResetReason",
  "EMCheckCompatibility",
  "EventLoopNestingLevel",
  "ExpectedStreamLen",
  "FlashProcessDump",
  "FramePoisonBase",
  "FramePoisonSize",
  "GMPLibraryPath",
  "GMPPlugin",
  "GPUProcessLaunchCount",
  "GPUProcessStatus",
  "GetHGlobalFromStreamFailure",
  "GraphicsCriticalError",
  "GraphicsSanityTest",
  "GraphicsStartupTest",
  "HangMonitorDescription",
  "HasDeviceTouchScreen",
  "IAccessibleConfig",
  "IPCFatalErrorMsg",
  "IPCFatalErrorProtocol",
  "IPCMessageName",
  "IPCMessageSize",
  "IPCReadErrorReason",
  "IPCShutdownState",
  "IPCSystemError",
  "IPCTransportFailureReason",
  "IndexedDBShutdownTimeout",
  "InstallTime",
  "InterfaceRegistrationInfoChild",
  "InterfaceRegistrationInfoParent",
  "IpcCreateEndpointsNsresult",
  "IpcCreatePipeCloExecErrno",
  "IpcCreatePipeFcntlErrno",
  "IpcCreatePipeSocketPairErrno",
  "IpcCreateTransportDupErrno",
  "IsGarbageCollecting",
  "IsWayland",
  "IsWaylandDRM",
  "JSActorMessage",
  "JSActorName",
  "JSLargeAllocationFailure",
  "JSOutOfMemory",
  "JavaStackTrace",
  "LauncherProcessState",
  "LocalStorageShutdownTimeout",
  "LowCommitSpaceEvents",
  "MainThreadRunnableName",
  "MarshalActCtxManifestPath",
  "MemoryErrorCorrection",
  "MozCrashReason",
  "Notes",
  "OOMAllocationSize",
  "PHCAllocStack",
  "PHCBaseAddress",
  "PHCFreeStack",
  "PHCKind",
  "PHCUsableSize",
  "PluginCpuUsage",
  "PluginFilename",
  "PluginHang",
  "PluginHangUIDuration",
  "PluginName",
  "PluginVersion",
  "ProcessType",
  "ProductID",
  "ProductName",
  "ProxyStreamSize",
  "ProxyStreamSizeFrom",
  "ProxyStreamUnmarshalStatus",
  "ProxyStreamValid",
  "PurgeablePhysicalMemory",
  "RDDProcessStatus",
  "ReleaseChannel",
  "RemoteType",
  "SafeMode",
  "SecondsSinceLastCrash",
  "ServerURL",
  "ShutdownProgress",
  "StartupCrash",
  "StartupTime",
  "StatFailure",
  "StorageConnectionNotClosed",
  "SubmittedFromInfobar",
  "SystemMemoryUsePercentage",
  "TelemetryClientId",
  "TelemetryEnvironment",
  "TelemetryServerURL",
  "TelemetrySessionId",
  "TestKey",
  "TestUnicode",
  "TextureUsage",
  "ThreadIdNameMapping",
  "TotalPageFile",
  "TotalPhysicalMemory",
  "TotalVirtualMemory",
  "URL",
  "UnknownNetAddrSocketFamily",
  "UnmarshalActCtx",
  "UnmarshalActCtxManifestPath",
  "UptimeTS",
  "User32BeforeBlocklist",
  "VRProcessStatus",
  "Vendor",
  "Version",
  "Winsock_LSP",
  "additional_minidumps",
  "ipc_channel_error",
  "nsAsyncShutdownComponent",
  "useragent_locale"
};

// Whitelist of crash annotations that can be included in a crash ping
const Annotation kCrashPingWhitelist[] = {
  Annotation::AsyncShutdownTimeout,
  Annotation::AvailablePageFile,
  Annotation::AvailablePhysicalMemory,
  Annotation::AvailableSwapMemory,
  Annotation::AvailableVirtualMemory,
  Annotation::BlockedDllList,
  Annotation::BlocklistInitFailed,
  Annotation::BuildID,
  Annotation::ContainsMemoryReport,
  Annotation::CrashTime,
  Annotation::DOMFissionEnabled,
  Annotation::EventLoopNestingLevel,
  Annotation::IndexedDBShutdownTimeout,
  Annotation::IsGarbageCollecting,
  Annotation::LocalStorageShutdownTimeout,
  Annotation::LowCommitSpaceEvents,
  Annotation::MainThreadRunnableName,
  Annotation::MemoryErrorCorrection,
  Annotation::MozCrashReason,
  Annotation::OOMAllocationSize,
  Annotation::ProductID,
  Annotation::ProductName,
  Annotation::PurgeablePhysicalMemory,
  Annotation::ReleaseChannel,
  Annotation::RemoteType,
  Annotation::SecondsSinceLastCrash,
  Annotation::ShutdownProgress,
  Annotation::StartupCrash,
  Annotation::SystemMemoryUsePercentage,
  Annotation::TextureUsage,
  Annotation::TotalPageFile,
  Annotation::TotalPhysicalMemory,
  Annotation::TotalVirtualMemory,
  Annotation::UptimeTS,
  Annotation::User32BeforeBlocklist,
  Annotation::ipc_channel_error
};

/**
 * Return the string representation of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns A constant string holding the annotation name
 */
static inline const char*
AnnotationToString(Annotation aAnnotation) {
  return kAnnotationStrings[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Converts a string to its corresponding crash annotation.
 *
 * @param aResult a reference where the annotation will be stored
 * @param aValue the string to be converted
 * @return true if the string was successfully converted, false if it did not
 *         correspond to any known annotation
 */
bool AnnotationFromString(Annotation& aResult, const char* aValue);

/**
 * Checks if the given crash annotation is whitelisted for inclusion in the
 * crash ping.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in the crash ping, false
 *         otherwise
 */
bool IsAnnotationWhitelistedForPing(Annotation aAnnotation);

/**
 * Abstract annotation writer, this is needed only for code that writes out
 * annotations in the exception handler.
 */
class AnnotationWriter {
 public:
  virtual void Write(Annotation aAnnotation, const char* aValue, size_t aLen = 0) = 0;
};

} // namespace CrashReporter

#endif // CrashAnnotations_h
