/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0

Dialog {
    id: root

    property CertificateRequest request

    DialogHeader {
        id: dialogHeader

        cancelText: ""
        //% "Select signification type and certificate subject"
        title: qsTrId("qca-la-type_signature")
    }

    backNavigation: false
    onAccepted: pageStack.animatorPush("ru.omp.qca.CreateCertificateRequestPage", { request: root.request })

    Column {
        anchors.top: dialogHeader.bottom
        width: parent.width

        ComboBox {
            width: parent.width
            //% "Type"
            label: qsTrId("qca-la-type")
            menu: ContextMenu {
                MenuItem {
                    //% "Qualified"
                    text: qsTrId("qca-me-qualified")
                }

                MenuItem {
                    //% "Nonqualified"
                    text: qsTrId("qca-me-nonqualified")
                }
            }
        }

        ComboBox {
            width: parent.width
            //% "Subject"
            label: qsTrId("qca-he-subject")
            menu: ContextMenu {
                MenuItem {
                    //% "Person"
                    text: qsTrId("qca-me-person")
                }

                MenuItem {
                    //% "Entity"
                    text: qsTrId("qca-me-entity")
                }
            }
        }
    }
}
