/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0

TextField {
    label: placeholderText
    onTextChanged: {
        label = placeholderText
        errorHighlight = false
    }
    onActiveFocusChanged: {
        if (text) {
            errorHighlight = false
            label = placeholderText
            hideLabelOnEmptyField = true
        } else if(!text && !focus){
            errorHighlight = true
            hideLabelOnEmptyField = false
            //% "Field must be completed"
            label = qsTrId("qca-ph-not_completed")
        }
    }
}
