/****************************************************************************
**
** SPDX-FileCopyrightText: 2021-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0

Dialog {
    id: root
    property int type
    property string fileName
    property string commonName

    acceptDestinationAction: PageStackAction.Replace

    DialogHeader {
        id: dialogHeader
        //% "Add certificate %1 to your device"
        title: qsTrId("qca-la-import_certificate").arg(fileName)
    }

    Column {
        anchors.top: dialogHeader.bottom
        width: parent.width

        DetailItem {
            //% "Common name"
            label: qsTrId("qca-p-la-common_name")
            value: root.commonName === undefined || commonName.length === 0 ? "-" : commonName
            alignment: Qt.AlignLeft
        }
    }
}
