/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

TouchBlocker {

    property alias error: labelError.text

    Rectangle {
        anchors.fill: parent
        opacity: Theme.opacityLow
        color: Theme.highlightDimmerColor
    }

    Column {
        x: Theme.horizontalPageMargin
        width: parent.width - 2*x
        spacing: Theme.paddingMedium
        anchors.verticalCenter: parent.verticalCenter

        HighlightImage {
            anchors.horizontalCenter: parent.horizontalCenter
            source: "image://theme/icon-l-attention"
            highlighted: true
            visible: labelError.text
        }

        Label {
            id: labelError
            width: parent.width
            wrapMode: Text.Wrap
            color: Theme.highlightColor
            horizontalAlignment: Text.AlignHCenter
        }
    }
}
