/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.4
import Sailfish.Silica 1.0
import ru.omp.qca 1.0
import Sailfish.Silica.private 1.0 as Private

Column {
    id: root

    property LoaderFile loaderFile
    property Component viewPdf
    property alias name: labelName.text

    width: parent.width

    InfoLabel {
        id: labelName

        text: mode === SignVerify.SignMode
              //% "Sign %1"
              ? qsTrId("qca-la-sign_file").arg(loaderFile.fileName)
              //% "Verify %1"
              : qsTrId("qca-la-verify_file").arg(loaderFile.fileName)
        wrapMode: Text.Wrap
        horizontalAlignment: Qt.AlignLeft
    }

    Label {
        x: Theme.horizontalPageMargin
        width: parent.width - x*2

        //% "To sign a document, you must view it to the end."
        text: qsTrId("qca-la-sign_comment")
        color: palette.secondaryColor
        wrapMode: Text.Wrap
    }

    Row {
        width: parent.width
        DetailItem {
            width: column.width * 0.7

            //% "Hash"
            label: qsTrId("qca-la-file_hash")
            value: loaderFile.fileHash
            forceValueBelow: true
            alignment: Qt.AlignLeft
            _valueItem.color: palette.secondaryColor
        }
        DetailItem {
            property int contentWidth: Math.max(fontMetrics.boundingRect(label).width, fontMetrics.boundingRect(value).width)

            width: contentWidth + leftMargin + rightMargin + Theme.paddingLarge

            //% "Size"
            label: qsTrId("qca-la-file_size")
            value: Format.formatFileSize(loaderFile.fileSize)
            forceValueBelow: true
            alignment: Qt.AlignLeft
            _valueItem.color: palette.secondaryColor

            FontMetrics {
                id: fontMetrics

                font.pixelSize: Theme.fontSizeSmall
            }
        }
    }

    Loader {
        onLoaded: item.documentProvider.rawData = loaderFile.rawData

        width: parent.width
        active: loaderFile.isPdf
        sourceComponent: viewPdf
    }

    Private.ZoomableFlickable {
        height: Math.min(parent.width, img.implicitHeight)
        width: parent.width
        contentHeight: img.height + Theme.paddingLarge
        implicitContentWidth: img.implicitWidth
        implicitContentHeight: img.implicitHeight
        clip: true
        visible: loaderFile.isImage && loaderFile.status === LoaderFile.Ready

        Image {
            id: img

            anchors.fill: parent
            source: loaderFile.isImage ? loaderFile.filePath : ""
        }
    }
}
