/****************************************************************************
**
** Copyright (C) 2021 Open Mobile Platform LLC
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    id: root

    signal remove()

    backNavigation: false
    backgroundColor: Theme.errorColor

    Column {
        id: content

        anchors.centerIn: parent
        width: parent.width
        spacing: Theme.paddingLarge

        Icon {
            anchors.horizontalCenter: parent.horizontalCenter
            source: "image://theme/icon-l-attention"
            color: Theme.primaryColor
        }

        Label {
            id: attention

            anchors.horizontalCenter: parent.horizontalCenter
            width: page.width - Theme.horizontalPageMargin * 2
            font.pixelSize: Theme.fontSizeHuge
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.Wrap
            //% "Attention!"
            text: qsTrId("qca-la-request_remove_root_crt_attention")
        }

        Label {
            anchors.horizontalCenter: parent.horizontalCenter
            width: attention.width
            font.pixelSize: Theme.fontSizeLargeBase
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.Wrap
            //% "Removing root certificate will compromise entire chain of trust"
            text: qsTrId("qca-la-remove_root_crt_warning")

        }

        Button {
            anchors.horizontalCenter: parent.horizontalCenter
            //% "Cancel"
            text: qsTrId("qca-bu-cancel")
            width: deleteButton.width
            height: deleteButton.height

            onClicked: pageStack.pop()
        }

        Button {
            id: deleteButton

            property int countdown: 5
            //% "Delete anyway"
            readonly property string buttonMsg: qsTrId("qca-bu-remove_root")

            anchors.horizontalCenter: parent.horizontalCenter
            width: page.width - Theme.horizontalPageMargin * 2
            height: Theme.itemSizeSmall
            enabled: countdown === 0
            border.color: countdown !== 0 ? Theme.primaryColor : "transparent"
            backgroundColor: countdown !== 0 ? "transparent" : Theme.rgba(color, Theme.opacityFaint)
            // Abbreviated seconds
            //% "(%1 s)"
            text: countdown !== 0 ? buttonMsg + " " +  qsTrId("qca-bu-countdown_seconds").arg(countdown) : buttonMsg

            onClicked: root.remove()
        }

        Timer {
            id: timerClose

            interval: 1000
            running: root.status === PageStatus.Active && deleteButton.countdown !== 0
            onTriggered: deleteButton.countdown = deleteButton.countdown - 1
        }
    }
}
