/****************************************************************************
**
** SPDX-FileCopyrightText: 2021-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0

Column {
    id: root

    property int contentCount: listView.count
    property var listModel
    property int type
    property string _searchPattern

    signal clicked()
    signal remove(int index)
    signal importing()


    width: parent.width
    height: listView.contentHeight

    SilicaListView {
        id: listView
        width: parent.width
        implicitHeight: contentItem.childrenRect.height
        model: listModel
        section.criteria: ViewSection.FirstCharacter
        section.property: "name"
        section.delegate: SectionHeader {
            text: section
            font.capitalization: Font.Capitalize
        }

        delegate: CertificateItem {
            function remorseDelete(action, timeout) {
                return remorseAction("", action, timeout)
            }

            function remorseAction(text, action, timeout) {
                return Remorse.itemAction(contentItem, text, action, timeout)
            }

            //% "Unnamed"
            name: model.name === undefined || model.name.length === 0 ? qsTrId("qca-se-unnamed") : model.name
            //% "Unknown organization"
            description: model.issuer === undefined || model.issuer.length === 0
                         ? qsTrId("qca-se-unknown_organization")
                         : model.issuer

            searchString: _searchPattern
            onClicked: {
                var infoPage = pageStack.push("ru.omp.qca.CertificateInfoPage", {
                                              'certificate' : model.certificate,
                                              'type' : root.type,
                                              'entryId' : root.type !== KeyStoreModel.Request ? model.entryId : "",
                                              'keyStoreEntry' : model.keyStoreEntry
                                              })
                infoPage.remove.connect(function() {
                    switch (root.type) {
                    case KeyStoreModel.Request:
                    case KeyStoreModel.User:
                        remorseDelete(function() { remove(model.index) } )
                        break
                    }
                })

                infoPage.importing.connect(function() {
                    importing()
                })
            }
        }
    }

    Component.onCompleted: {
        componentHeader.createObject(listView)
    }
}
