/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0

Item {
    property var certificate

    width: parent.width
    height: certHeader.height + certInfo.height + Theme.paddingMedium
    Label {
        id: certHeader
        x: Theme.horizontalPageMargin
        width: parent.width - x*2
        //% "Information about the ES certificate"
        text: qsTrId("qca-la-info_es_certificate")

    }
    Grid {
        id: certInfo
        anchors {
            top: certHeader.bottom
            topMargin: Theme.paddingMedium
        }
        width: parent.width
        columns: isPhone ? 1 : isPortrait ? 2 : 3

        spacing: Theme.paddingMedium
        property int cellWidth: certInfo.width / certInfo.columns - spacing * (certInfo.columns - 1)

        DetailItem {
            //% "Certificate"
            label: qsTrId("qca-la-certificate")
            value: certificate ? certificate.serialNumber : ""
            width: certInfo.cellWidth
            forceValueBelow: true
            alignment: Qt.AlignLeft
            _valueItem.color: palette.secondaryColor

        }
        DetailItem {
            //% "Valid"
            label: qsTrId("qca-la-cert_valid")
            //% "From %1 to %2"
            value: qsTrId("qca-va-cert_valid")
            .arg(certificate ? certificate.notValidBefore : "")
            .arg(certificate ? certificate.notValidAfter : "")
            width: certInfo.cellWidth
            forceValueBelow: true
            alignment: Qt.AlignLeft
            _valueItem.color: palette.secondaryColor

        }
        DetailItem {
            //% "Issued to"
            label: qsTrId("qca-la-cert_issued_to")
            value: certificate ? certificate.commonName : ""
            width: certInfo.cellWidth
            forceValueBelow: true
            alignment: Qt.AlignLeft
            _valueItem.color: palette.secondaryColor

        }
    }
}
