/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0
import ru.omp.qca.private 1.0

Page {
    id: page
    // Maximum waiting time
    property int waitingKeystoreTimerInterval: 25 * 1000
    property alias labelText: statusLabel.text
    property string iconSource
    property bool visibleSuccessful: true

    signal done()

    function wait() {
        state = WaitState.waiting
        waitingKeystoreTimer.start()
        visible = true
        timerBeforePush.stop()
        timerBeforeClose.stop()
    }

    function successful() {
        if (state === WaitState.waiting || state === WaitState.stop) {
            waitingKeystoreTimer.stop()
            timerBeforeClose.stop()
            visible = true

            if (visibleSuccessful) {
                state = WaitState.sucessfull
                timerBeforePush.start()
            } else {
                state = WaitState.waiting
                timerBeforePush.start()
            }
        }
    }

    function stop() {
        state = WaitState.stop
        visible = false
        waitingKeystoreTimer.stop()
        timerBeforePush.stop()
        timerBeforeClose.stop()
        pageStack.pop(undefined, PageStackAction.Immediate)
    }

    function warning() {
        state = WaitState.warning
        visible = true
        waitingKeystoreTimer.stop()
        timerBeforePush.stop()
        timerBeforeClose.start()
    }

    backNavigation: false

    Column {
        id: indicatorColumn

        property alias visibleBusyIndicator: busyIndicator.visible

        anchors.centerIn: parent
        spacing: Theme.paddingSmall
        opacity: busyIndicator.opacity

        Icon {
            anchors.horizontalCenter: parent.horizontalCenter
            color: Theme.secondaryHighlightColor
            source: page.iconSource
        }

        BusyIndicator {
            id: busyIndicator

            anchors.horizontalCenter: parent.horizontalCenter
            color: Theme.secondaryHighlightColor
            size: BusyIndicatorSize.Large
            running: true
        }

        Label {
            id: statusLabel
            width: page.width - Theme.horizontalPageMargin * 2
            visible: text.length > 0
            font.pixelSize: Theme.fontSizeSmall
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.Wrap
            color: Theme.secondaryHighlightColor
        }
    }

    states: [
        State {
            name: WaitState.sucessfull
            PropertyChanges {
                target: page
                iconSource: "image://theme/icon-l-acknowledge"
                //% "Done"
                labelText: qsTrId("qca-la-generation_done")
            }

            PropertyChanges {
                target: indicatorColumn
                visibleBusyIndicator: false
            }
        },
        State {
            name: WaitState.waiting
            PropertyChanges {
                target: page
                iconSource: ""
            }

            PropertyChanges {
                target: indicatorColumn
                visibleBusyIndicator: true
            }
        },
        State {
            name: WaitState.warning
            PropertyChanges {
                target: page
                iconSource: "image://theme/icon-l-attention"
                //% "Error"
                labelText: qsTrId("qca-la-generation_error")
            }

            PropertyChanges {
                target: indicatorColumn
                visibleBusyIndicator: false
            }
        },
        State {
            name: WaitState.stop
            PropertyChanges {
                target: page
                iconSource: ""
                labelText: ""
            }

            PropertyChanges {
                target: indicatorColumn
                visibleBusyIndicator: false
            }
        },
        State {
            name: WaitState.stop
            PropertyChanges {
                target: page
                iconSource: ""
                lableText: ""
            }

            PropertyChanges {
                target: indicatorColumn
                visibleBusyIndicator: false
            }
        }
    ]

    Timer {
        id: waitingKeystoreTimer

        interval: waitingKeystoreTimerInterval
        onTriggered: {
            warning()
        }
    }

    Timer {
        id: timerBeforePush

        interval: 2500
        onTriggered: {
            done()
            visible = false
        }
    }

    Timer {
        id: timerBeforeClose

        interval: 2500
        onTriggered: {
            pageStack.pop()
            visible = false
        }
    }
}
