/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    property Page targetPage: null
    property bool enabled: false

    property bool _backNavigation: true
    property bool _forwardNavigation: true

    onEnabledChanged: {
        if (enabled) {
            targetPage.opacity = 0.05
            _backNavigation = targetPage.backNavigation
            _forwardNavigation = targetPage.forwardNavigation
            targetPage.backNavigation = false
            targetPage.forwardNavigation = false
        } else {
            targetPage.opacity = 1.0
            targetPage.backNavigation = _backNavigation
            targetPage.forwardNavigation = _forwardNavigation
        }
    }
}
