/****************************************************************************
**
** Copyright (c) 2023 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.6
import Sailfish.Silica 1.0

Dialog {
    id: root

    property alias password: passwordField.text

    canAccept: password.length > 0

    Column {
        width: parent.width

        DialogHeader {
            //% "Accept"
            acceptText: qsTrId("qca-he-accept")
            //% "Cancel"
            cancelText: qsTrId("qca-he-cancel")
        }

        Label {
            anchors {
                left: parent.left
                leftMargin: Theme.horizontalPageMargin
                right: parent.right
                rightMargin: Theme.paddingLarge
            }
            wrapMode: Text.Wrap
            color: Theme.highlightColor
            font.pixelSize: Theme.fontSizeExtraLarge
            //% "Enter certificate password"
            text: qsTrId("qca-he-enter-cert-password")
        }

        Item { width: 1; height: Theme.paddingLarge }

        PasswordField {
            id: passwordField

            EnterKey.onClicked: root.accept()
            EnterKey.iconSource: "image://theme/icon-m-enter-accept"
            EnterKey.enabled: text || inputMethodComposing

            showEchoModeToggle: true
        }
    }
}
