/****************************************************************************
**
** Copyright (c) 2020 - 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import QtQuick.Layouts 1.1
import Sailfish.Silica 1.0
import ru.omp.qca 1.0
import "private"

Page {
    id: page

    property string fileName
    property var certificate
    property int mode
    readonly property bool isPhone: Screen.sizeCategory == Screen.Medium
    property bool isLoaded: certificate != undefined

    SilicaFlickable {
        anchors.fill: parent
        contentHeight: column.height + Theme.paddingLarge
        Column {
            id: column

            width: parent.width
            spacing: Theme.paddingLarge
            PageHeader {
                id: header

                title: mode == SignVerify.SignMode
                       //% "Document signed"
                       ? qsTrId("qca-he-documet_signed")
                       //% "Document verified"
                       : qsTrId("qca-he-documet_verified")
            }

            Item {
                x: Theme.horizontalPageMargin
                width: parent.width - x*2
                height: childrenRect.height
                Icon {
                    id: icon

                    source: "image://theme/icon-l-acknowledge"
                }
                Label {
                    anchors {
                        left: icon.right
                        leftMargin: Theme.paddingMedium
                        right: parent.right
                        verticalCenter: icon.verticalCenter
                    }

                    text: mode == SignVerify.SignMode
                          //% "Successfully signed!"
                          ? qsTrId("qca-la-successfully_signed")
                          //% "Successfully verified!"
                          : qsTrId("qca-la-successfully_verified")
                    wrapMode: Text.Wrap
                }
            }

            Label {
                x: Theme.horizontalPageMargin
                width: parent.width - x*2
                text: fileName
                color: palette.highlightColor
                wrapMode: Text.Wrap
            }

            CertificateBaseInfo {
                certificate: page.certificate
            }

        }
        VerticalScrollDecorator {}
    }
}
