/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0
import "private"

Page {
    id: root

    property CertificateRequest request
    property bool isQualified
    property bool isPhysical
    property bool isEdit

    property string keyId: request.publicKeyId
    property string algorithm: request.publicKeyTypeAlgorithm
    property string marker: request.publicKeyMarker
    property string availability: request.privateKeyAvailability
    property string location: request.privateKeyLocation
    property string manufacturer: request.privateKeyManufacturer

    function clearFields() {
        emailField.text = ""
        countryCodeField.text = ""
        countryField.text = ""
        commonField.text = ""
        cityField.text = ""
        addressField.text = ""
        organizationField.text = ""
        departmentField.text = ""
        positionField.text = ""
//  TODO - qca cannot save this data
//        surnameField.text = ""
//        nameField.text = ""
//        psrnField.text = ""
//        snilsField.text = ""
//        tinField.text = ""
    }

    backNavigation: isEdit

    SilicaFlickable {
        width: parent.width
        height: parent.height
        contentHeight: header.height + column.height

        PullDownMenu {
            MenuItem {
                onClicked: clearFields()
                //% "Clear text fields"
                text: qsTrId("qca-me-clear")
            }
        }

        PageHeader {
            id: header
            //% "Request for certificate"
            title: qsTrId("qca-he-certificate_request")
        }

        Column {
            id: column
            width: parent.width
            anchors.top: header.bottom

            SectionHeader {
                //% "Subject"
                text: qsTrId("qca-he-subject")
            }

//          TODO - qca cannot save this data
//            RequiredTextField {
//                id: surnameField
//                width: parent.width
//                //% "Curname %1"
//                placeholderText: qsTrId("qca-ph-surname").arg("SN*")
//            }

//            RequiredTextField {
//                id: nameField
//                width: parent.width
//                //% "Name %1"
//                placeholderText: qsTrId("qca-ph-name").arg("G*")
//                onTextChanged: request.setName(text)
//            }

            RequiredTextField {
                id: emailField
                width: parent.width
                //% "Email %1"
                placeholderText: qsTrId("qca-ph-email").arg("E*")
                text: request.subjectEmail
            }

            RequiredTextField {
                id: commonField
                width: parent.width
                //% "Common Name %1"
                placeholderText: qsTrId("qca-ph-common_name").arg("CN*")
                text: request.commonName
            }

            TextField {
                id: countryCodeField
                width: parent.width
                //% "Code %1"
                placeholderText: qsTrId("qca-ph-country_code").arg("C")
                label: placeholderText
                text: request.subjectCountryCode
            }

            TextField {
                id: countryField
                width: parent.width
                //% "State %1"
                placeholderText: qsTrId("qca-ph-state").arg("ST")
                label: placeholderText
                text: request.subjectCountry
            }

            TextField {
                id: cityField
                width: parent.width
                //% "Settlement %1"
                placeholderText: qsTrId("qca-ph-settlement").arg("L")
                label: placeholderText
                text: request.subjectLocality
            }

            TextField {
                id: addressField
                width: parent.width
                //% "Address"
                placeholderText: qsTrId("qca-ph-address")
                label: placeholderText
                text: request.subjecAddress
            }

            RequiredTextField {
                id: organizationField
                width: parent.width
                //% "Organization %1"
                placeholderText: qsTrId("qca-ph-organization").arg("O*")
                text: request.subjectOrganization
            }

            TextField {
                id: departmentField
                width: parent.width
                //% "Department %1"
                placeholderText: qsTrId("qca-ph-department").arg("OU")
                label: placeholderText
                visible: !isPhysical && isEdit
                text: request.subjectOrganizationalUnit
            }

            TextField {
                id: positionField
                width: parent.width
                //% "Position %1"
                placeholderText: qsTrId("qca-ph-position").arg("T")
                label: placeholderText
                visible: !isPhysical
            }

//          TODO - qca cannot save this data
//            TextField {
//                id: snilsField
//                width: parent.width
//                //% "INILA"
//                placeholderText: qsTrId("qca-ph-inila")
//                label: placeholderText
//                visible: isPhysical
//            }

//            TextField {
//                id: psrnField
//                width: parent.width
//                //% "PSRN"
//                placeholderText: qsTrId("qca-ph-psrn")
//                label: placeholderText
//                visible: !isPhysical
//            }

//            TextField {
//                id: tinField
//                width: parent.width
//                //% "TIN"
//                placeholderText: qsTrId("qca-ph-tin")
//                label: placeholderText
//                visible: isQualified
//            }

            SectionHeader {
                //% "Opened key"
                text: qsTrId("qca-ph-opened_key")
            }

            DetailItem {
                id: keyIdItem
                //% "Key Identifier"
                label: qsTrId("qca-la-identifier")
                value: root.keyId === undefined || root.keyId.length === 0 ? "-" : root.keyId
                width: parent.width
                alignment: Qt.AlignLeft
            }

            DetailItem {
                id: algorithmLabel
                //% "Key algorithm"
                label: qsTrId("qca-la-encription")
                value: root.algorithm === undefined || root.algorithm.length === 0 ? "-" : root.algorithm
                width: parent.width
                alignment: Qt.AlignLeft
            }

            DetailItem {
                id: markerItem
                //% "Marker"
                label: qsTrId("qca-ph-marker")
                value: root.marker === undefined || root.marker.length === 0 ? "-" : root.marker
                width: parent.width
                alignment: Qt.AlignLeft
            }

            SectionHeader {
                //% "Closed key"
                text: qsTrId("qca-ph-closed_key")
            }

            DetailItem {
                id: availabilityItem
                //% "Availability"
                label: qsTrId("qca-la-availability")
                value: root.availability === undefined || root.availability.length === 0 ? "-" : root.availability
                width: parent.width
                alignment: Qt.AlignLeft
            }

            DetailItem {
                id: locationItem
                //% "Location"
                label: qsTrId("qca-la-location")
                value: root.location === undefined || root.location.length === 0 ? "-" : root.location
                width: parent.width
                alignment: Qt.AlignLeft
            }

            DetailItem {
                id: manufacturerItem
                //% "Manufacturer"
                label: qsTrId("qca-la-manufacturer")
                value: root.manufacturer === undefined || root.manufacturer.length === 0 ? "-" : root.manufacturer
                width: parent.width
                alignment: Qt.AlignLeft
            }

            Button {
                               //% "Save"
                text: isEdit ? qsTrId("qca-bu-save_request")
                               //% "Create request"
                             : qsTrId("qca-bu-create_request")
                width: Theme.buttonWidthLarge
                height: Theme.itemSizeMedium
                anchors.horizontalCenter: parent.horizontalCenter
                onClicked: {
                    request.setEmail(emailField.text)
                    request.setCommonName(commonField.text)
                    request.setCountryCode(countryCodeField.text)
                    request.setCountry(countryField.text)
                    request.setLocality(cityField.text)
                    request.setAddress(addressField.text)
                    request.setOrganization(organizationField.text)
                    request.setDepartment(departmentField.text)
                    request.setPosition(positionField.text)
//              TODO - qca cannot save this data
//                    request.setCurname(surnameField.text)
//                    request.setName(nameField.text)
//                    request.setSnils(snilsField.text)
//                    request.setPsrn(psrnField.text)
//                    request.setTin(tinField.text)

                    if (isEdit) {
                        request.setEditMode(isEdit)
                        var certificatePage = pageStack.find(function(page) { return page.hasOwnProperty('__hasPersonal') })
                        pageStack.pop(certificatePage)
                    } else {
                         request.createRequest()
                    }
                }
//              TODO - qca cannot save this data
                enabled:/* surnameField.text.length > 0
                         && nameField.text.length > 0
                         &&*/
                        organizationField.text.length > 0
                        && emailField.text.length > 0
                        && commonField.text.length > 0
            }
        }
        VerticalScrollDecorator {}
    }
    Connections {
        target: root.request
        onMissingPrivateKey: pageStack.animatorPush("ru.omp.qca.private.StatusPage", {
                                                        initialPath: request.requestPath(),
                                                        fileName: request.fileName,
                                                        type: KeyStoreModel.Request,
                                                        errorStatus: true,
                                                        //% "Private key creation error"
                                                        description: qsTrId("qca-la-request_pr_key_error")
                                                    })
    }
}
