/****************************************************************************
**
** SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.qca 1.0
import ru.omp.qca.private 1.0
import Aurora.Controls 1.0

Page {
    id: root

    property alias type: firstFilterModel.filterRole
    property alias sourceModel: firstFilterModel.sourceModel
    property var requestModel

    property var secondComponentObject

    CertificateModel {
        id: firstFilterModel

        searchRoles: ['issuer', 'name' ]
    }

    CertificateModel {
        id: filterSecondaryModel

        filterRole:  root.type === KeyStoreModel.Imported ? KeyStoreModel.RootImported : KeyStoreModel.Request
        searchRoles: [ 'issuer', 'name' ]
        sourceModel: root.type === KeyStoreModel.Imported ? KeyStoreModel : requestModel
    }

    AppBar {
        id: headerBar

        AppBarSpacer {}

        AppBarSearchField {
            id: searchField

            onTextChanged: {
                firstFilterModel.pattern = text 
                if (root.type !== KeyStoreModel.System)
                    filterSecondaryModel.pattern = text
            }

            width: parent.width
            backgroundEnabled: true

            //% "Search by certificates"
            placeholderText: qsTrId("qca-se-search_by_certificates")

            Component.onCompleted: searchField.forceActiveFocus()
        }
    }

    SilicaFlickable {
        anchors {
            horizontalCenter: parent.horizontalCenter
            top: headerBar.bottom
        }

        width: parent.width
        height: parent.height - headerBar.height
        contentHeight: data.childrenRect.height

        Column {
            id: data
            width: parent.width

            Component {
                id: secondComponent

                CertificateSectionListItem {
                    onRemove: requestModel.remove(index)
                    onContentCountChanged: busyIndicator.running = false

                    listModel: filterSecondaryModel
                    type: root.type === KeyStoreModel.Imported ? KeyStoreModel.RootImported : KeyStoreModel.Request
                    visible: busyIndicator.running
                }
            }

            CertificateSectionListItem {
                id: certificateList

                listModel: firstFilterModel
                type: root.type
                _searchPattern: searchField.text
            }
        }

        VerticalScrollDecorator {}
    }

    Component.onCompleted: {
        firstFilterModel.pattern = ""
        if (type === KeyStoreModel.SmartCard) {
            requestModel.init()
            secondComponentObject = secondComponent.createObject(data)
        }

        if (type === KeyStoreModel.Imported)
            secondComponentObject = secondComponent.createObject(data)
    }
}
