/****************************************************************************
**
** Copyright (c) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0

BackgroundItem {
    id: delegateItem

    property string name
    property string description
    property int type
    property string searchString

    width: parent.width
    height: column.height + Theme.paddingMedium*2

    Column {
        id: column

        x: Theme.horizontalPageMargin
        width: parent.width - x*2
        y: Theme.paddingMedium

        Label {
            id: nameLabel

            width: parent.width
            color: delegateItem.highlighted ? Theme.highlightColor : Theme.primaryColor
            wrapMode: Text.Wrap
            text: Theme.highlightText(name.substr(0, Math.min(name.length, 300)), searchString, Theme.highlightColor)
            textFormat: Text.StyledText
        }

        Label {
            id: descriptionLabel

            width: parent.width
            font.pixelSize: Theme.fontSizeSmall
            color: delegateItem.highlighted ? Theme.secondaryHighlightColor : Theme.secondaryColor
            wrapMode: Text.Wrap
            text: Theme.highlightText(description.substr(0, Math.min(description.length, 300)), searchString, Theme.highlightColor)
            textFormat: Text.StyledText
        }
    }
}
